function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import createGuid from "../../__internal__/utils/helpers/guid";
import Heading from "../heading";
import Dialog from "../dialog";
import { StyledConfirmButtons, StyledConfirmHeading } from "./confirm.style";
import Button from "../button/button.component";
import Icon from "../icon";
import Loader from "../loader";
import useLocale from "../../hooks/__internal__/useLocale";
import tagComponent from "../../__internal__/utils/helpers/tags";
export const Confirm = ({
  "aria-labelledby": ariaLabelledBy,
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  open,
  children,
  cancelButtonDestructive = false,
  confirmButtonDestructive = false,
  cancelButtonType = "secondary",
  confirmButtonType = "primary",
  cancelButtonIconType,
  cancelButtonIconPosition,
  confirmButtonIconType,
  confirmButtonIconPosition,
  cancelButtonDataProps,
  confirmButtonDataProps,
  cancelLabel,
  onCancel,
  disableCancel,
  onConfirm,
  isLoadingConfirm,
  disableConfirm,
  confirmLabel,
  iconType,
  subtitle,
  title,
  size = "extra-small",
  showCloseIcon = false,
  topModalOverride,
  ...rest
}) => {
  const l = useLocale();
  const {
    current: titleId
  } = useRef(createGuid());
  const {
    current: subtitleId
  } = useRef(createGuid());
  const ariaProps = {
    "aria-labelledby": ariaLabelledBy,
    "aria-describedby": ariaDescribedBy,
    "aria-label": ariaLabel
  };
  if (title && iconType) {
    ariaProps["aria-labelledby"] = titleId;
  }
  if (subtitle && iconType) {
    ariaProps["aria-describedby"] = subtitleId;
  }
  const renderCancelButton = () => {
    if (!onCancel) return null;
    return /*#__PURE__*/React.createElement(Button, _extends({
      onClick: onCancel,
      buttonType: cancelButtonType,
      destructive: cancelButtonDestructive,
      disabled: disableCancel,
      iconType: cancelButtonIconType,
      iconPosition: cancelButtonIconPosition
    }, tagComponent("cancel", {
      "data-element": "cancel",
      ...cancelButtonDataProps
    })), cancelLabel || l.confirm.no());
  };
  const renderConfirmButton = () => /*#__PURE__*/React.createElement(Button, _extends({
    onClick: onConfirm,
    buttonType: confirmButtonType,
    destructive: confirmButtonDestructive,
    disabled: isLoadingConfirm || disableConfirm,
    ml: 2,
    iconType: confirmButtonIconType,
    iconPosition: confirmButtonIconPosition
  }, tagComponent("confirm", {
    "data-element": "confirm",
    ...confirmButtonDataProps
  })), isLoadingConfirm ? /*#__PURE__*/React.createElement(Loader, {
    isInsideButton: true,
    isActive: true
  }) : confirmLabel || l.confirm.yes());
  const getTitle = () => {
    if (iconType) {
      return /*#__PURE__*/React.createElement(StyledConfirmHeading, {
        type: iconType,
        "data-element": iconType
      }, /*#__PURE__*/React.createElement(Icon, {
        type: iconType,
        fontSize: "medium"
      }), /*#__PURE__*/React.createElement(Heading, {
        title: title,
        titleId: titleId,
        subheader: subtitle,
        subtitleId: subtitleId,
        divider: false
      }));
    }
    return title;
  };
  return /*#__PURE__*/React.createElement(Dialog, _extends({
    open: open,
    onCancel: onCancel,
    disableClose: disableCancel,
    subtitle: subtitle,
    title: getTitle(),
    "data-component": "confirm",
    role: "alertdialog",
    size: size,
    showCloseIcon: showCloseIcon,
    topModalOverride: topModalOverride
  }, ariaProps, rest), children, /*#__PURE__*/React.createElement(StyledConfirmButtons, null, renderCancelButton(), renderConfirmButton()));
};
export default Confirm;