import React from "react";
import { DialogProps } from "../dialog";
import { IconType } from "../icon";
import { TagProps } from "../../__internal__/utils/helpers/tags";
export interface ConfirmProps extends Omit<DialogProps, "className" | "disableFocusTrap" | "bespokeFocusTrap" | "focusableSelectors" | "help" | "role" | "contentPadding" | "focusableContainers" | "ariaRole" | "timeout" | "enableBackgroundUI" | "disableClose"> {
    /** Color variants for new business themes: "primary" | "secondary" | "tertiary" | "darkBackground" */
    cancelButtonType?: "primary" | "secondary" | "tertiary" | "darkBackground";
    /** Color variants for new business themes: "primary" | "secondary" | "tertiary" | "darkBackground" */
    confirmButtonType?: "primary" | "secondary" | "tertiary" | "darkBackground";
    /** Customise the cancel button label */
    cancelLabel?: string;
    /** Customise the confirm button label */
    confirmLabel?: string;
    /** Apply destructive style to the cancel button */
    cancelButtonDestructive?: boolean;
    /** Apply destructive style to the confirm button */
    confirmButtonDestructive?: boolean;
    /** Defines a cancel button Icon position related to the children: "before" | "after" */
    cancelButtonIconPosition?: "before" | "after";
    /** Defines an Icon type within the cancel button (see Icon for options) */
    cancelButtonIconType?: IconType;
    /** Defines a cancel button Icon position related to the children: "before" | "after" */
    confirmButtonIconPosition?: "before" | "after";
    /** Defines an Icon type within the confirm button (see Icon for options) */
    confirmButtonIconType?: IconType;
    /** Data tag prop bag for cancelButton */
    cancelButtonDataProps?: TagProps;
    /** Data tag prop bag for confirmButton */
    confirmButtonDataProps?: TagProps;
    /** Makes cancel button disabled */
    disableCancel?: boolean;
    /** Makes confirm button disabled */
    disableConfirm?: boolean;
    /** Defines an Icon type within the button (see Icon for options) */
    iconType?: "error" | "warning";
    /** Adds isLoading state into confirm button */
    isLoadingConfirm?: boolean;
    /** A custom event handler when a confirmation takes place */
    onConfirm: (ev: React.MouseEvent<HTMLButtonElement>) => void;
}
export declare const Confirm: ({ "aria-labelledby": ariaLabelledBy, "aria-describedby": ariaDescribedBy, "aria-label": ariaLabel, open, children, cancelButtonDestructive, confirmButtonDestructive, cancelButtonType, confirmButtonType, cancelButtonIconType, cancelButtonIconPosition, confirmButtonIconType, confirmButtonIconPosition, cancelButtonDataProps, confirmButtonDataProps, cancelLabel, onCancel, disableCancel, onConfirm, isLoadingConfirm, disableConfirm, confirmLabel, iconType, subtitle, title, size, showCloseIcon, topModalOverride, ...rest }: ConfirmProps) => React.JSX.Element;
export default Confirm;
