import React from "react";
import { MarginProps } from "styled-system";
import { CommonCheckableInputProps } from "../../__internal__/checkable-input/checkable-input.component";
export interface CheckboxProps extends CommonCheckableInputProps, MarginProps {
    /** Breakpoint for adaptive spacing (left margin changes to 0). Enables the adaptive behaviour when set */
    adaptiveSpacingBreakpoint?: number;
    /** Prop to specify the aria-labelledby property of the input */
    "aria-labelledby"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
    /** When true label is inline */
    labelInline?: boolean;
    /** Accepts a callback function which is triggered on click event */
    onClick?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** The value of the checkbox, passed on form submit */
    value?: string;
}
export declare const Checkbox: React.ForwardRefExoticComponent<CheckboxProps & React.RefAttributes<HTMLInputElement>>;
export default Checkbox;
