function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import StyledCheckboxGroup, { StyledHintText } from "./checkbox-group.style";
import Fieldset from "../../../__internal__/fieldset";
import { filterStyledSystemMarginProps } from "../../../style/utils";
import { TooltipProvider } from "../../../__internal__/tooltip-provider";
import FormSpacingProvider from "../../../__internal__/form-spacing-provider";
import { NewValidationContext } from "../../carbon-provider/carbon-provider.component";
import ValidationMessage from "../../../__internal__/validation-message/validation-message.component";
import Box from "../../box";
import { ErrorBorder } from "../../textbox/textbox.style";
export const CheckboxGroupContext = /*#__PURE__*/React.createContext({});
export const CheckboxGroup = props => {
  const {
    validationRedesignOptIn
  } = useContext(NewValidationContext);
  const {
    children,
    legend,
    error,
    warning,
    info,
    required,
    isOptional,
    legendInline,
    legendWidth,
    legendAlign,
    legendSpacing,
    legendHelp,
    tooltipPosition,
    inline
  } = props;
  return /*#__PURE__*/React.createElement(React.Fragment, null, validationRedesignOptIn ? /*#__PURE__*/React.createElement(Fieldset, _extends({
    legend: legend,
    inline: legendInline,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    error: error,
    warning: warning,
    info: info,
    isRequired: required,
    isOptional: isOptional
  }, tagComponent("checkboxgroup", props), {
    blockGroupBehaviour: !(error || warning)
  }, filterStyledSystemMarginProps(props)), legendHelp && /*#__PURE__*/React.createElement(StyledHintText, null, legendHelp), /*#__PURE__*/React.createElement(Box, {
    position: "relative"
  }, /*#__PURE__*/React.createElement(ValidationMessage, {
    error: error,
    warning: warning
  }), (error || warning) && /*#__PURE__*/React.createElement(ErrorBorder, {
    warning: !!(!error && warning),
    inline: inline
  }), /*#__PURE__*/React.createElement(StyledCheckboxGroup, {
    "data-component": "checkbox-group",
    legendInline: legendInline,
    inline: inline
  }, /*#__PURE__*/React.createElement(CheckboxGroupContext.Provider, {
    value: {
      error: !!error,
      warning: !!warning
    }
  }, /*#__PURE__*/React.createElement(FormSpacingProvider, {
    marginBottom: undefined
  }, children))))) : /*#__PURE__*/React.createElement(TooltipProvider, {
    tooltipPosition: tooltipPosition
  }, /*#__PURE__*/React.createElement(Fieldset, _extends({
    legend: legend,
    inline: legendInline,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    error: error,
    warning: warning,
    info: info,
    isRequired: required,
    isOptional: isOptional
  }, tagComponent("checkboxgroup", props), {
    blockGroupBehaviour: !(error || warning || info)
  }, filterStyledSystemMarginProps(props)), /*#__PURE__*/React.createElement(StyledCheckboxGroup, {
    "data-component": "checkbox-group",
    legendInline: legendInline
  }, /*#__PURE__*/React.createElement(CheckboxGroupContext.Provider, {
    value: {
      error: !!error,
      warning: !!warning,
      info: !!info
    }
  }, /*#__PURE__*/React.createElement(FormSpacingProvider, {
    marginBottom: undefined
  }, children))))));
};
CheckboxGroup.displayName = "CheckboxGroup";
export default CheckboxGroup;