import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../../../__internal__/validations";
export interface CheckboxGroupProps extends ValidationProps, MarginProps {
    /** The content for the CheckboxGroup Legend */
    legend?: string;
    /** The content for the CheckboxGroup Legend Help text  */
    legendHelp?: string;
    /** When true, legend is placed inline with the checkboxes */
    legendInline?: boolean;
    /** Percentage width of legend (only when legend is inline)  */
    legendWidth?: number;
    /** Text alignment of legend when inline */
    legendAlign?: "left" | "right";
    /** Spacing between legend and field for inline legend, number multiplied by base spacing unit (8) */
    legendSpacing?: 1 | 2;
    /** The Checkboxes to be rendered in the group */
    children: React.ReactNode;
    /** Spacing between label and a field for inline label, given number will be multiplied by base spacing unit (8) */
    labelSpacing?: 1 | 2;
    /** Flag to configure component as mandatory */
    required?: boolean;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
    /** Overrides the default tooltip */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** When true, Checkboxes are in line */
    inline?: boolean;
}
export declare const CheckboxGroupContext: React.Context<ValidationProps>;
export declare const CheckboxGroup: {
    (props: CheckboxGroupProps): React.JSX.Element;
    displayName: string;
};
export default CheckboxGroup;
