function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useRef, useState, useMemo } from "react";
import PropTypes from "prop-types";
import Logger from "../../__internal__/utils/logger";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { CarouselPreviousButtonWrapperStyle, CarouselNextButtonWrapperStyle, CarouselButtonStyle, CarouselStyledIconRight, CarouselStyledIconLeft, CarouselSelectorWrapperStyle, CarouselSelectorInputWrapperStyle, CarouselSelectorInputStyle, CarouselSelectorLabelStyle, CarouselWrapperStyle, CarouselSliderWrapper } from "./carousel.style";
import guid from "../../__internal__/utils/helpers/guid";
let deprecateWarnTriggered = false;
const NEXT = "next";
const PREVIOUS = "previous";
export const Carousel = ({
  children,
  className,
  enableSlideSelector = true,
  enablePreviousButton = true,
  enableNextButton = true,
  initialSlideIndex = 0,
  onSlideChange,
  slideIndex,
  ...props
}) => {
  if (!deprecateWarnTriggered) {
    deprecateWarnTriggered = true;
    Logger.deprecate("The Carousel component is deprecated and will soon be removed.");
  }
  const [selectedSlideIndex, setSelectedSlideIndex] = useState(Number(slideIndex) || Number(initialSlideIndex));
  const transitionDirection = useRef(NEXT);
  const lastSlideIndexProp = useRef(slideIndex);
  const id = useMemo(() => guid(), []);
  const numOfSlides = useMemo(() => {
    return React.Children.toArray(children).filter(child => /*#__PURE__*/React.isValidElement(child)).length;
  }, [children]);
  const handleSlideChange = useCallback(newIndex => {
    setSelectedSlideIndex(newIndex);
    if (onSlideChange) {
      onSlideChange(newIndex, transitionDirection.current);
    }
  }, [onSlideChange]);
  useEffect(() => {
    const newIndex = slideIndex;
    const isNewIndexUndefined = typeof newIndex === "undefined";
    const isTheSameIndex = newIndex === lastSlideIndexProp.current || newIndex === selectedSlideIndex;
    if (isNewIndexUndefined || isTheSameIndex) return;
    if (Number(newIndex) > Number(selectedSlideIndex)) {
      transitionDirection.current = NEXT;
    } else {
      transitionDirection.current = PREVIOUS;
    }
    lastSlideIndexProp.current = newIndex;
    handleSlideChange(newIndex);
  }, [handleSlideChange, slideIndex, selectedSlideIndex]);
  function onPreviousClick() {
    const newIndex = selectedSlideIndex - 1;
    transitionDirection.current = PREVIOUS;
    handleSlideChange(newIndex);
  }
  function onNextClick() {
    const newIndex = selectedSlideIndex + 1;
    transitionDirection.current = NEXT;
    handleSlideChange(newIndex);
  }
  function onSlideSelection(ev) {
    const newSlideSelection = Number(ev.target.value);
    transitionDirection.current = newSlideSelection > selectedSlideIndex ? NEXT : PREVIOUS;
    handleSlideChange(newSlideSelection);
  }
  function slideSelector() {
    if (!enableSlideSelector) return null;
    const buttons = [];
    for (let i = 0; i < numOfSlides; i++) {
      buttons.push( /*#__PURE__*/React.createElement(CarouselSelectorInputWrapperStyle, {
        key: i,
        "data-element": "selector-inputs"
      }, /*#__PURE__*/React.createElement(CarouselSelectorInputStyle, {
        "data-element": "selector-input",
        name: `carousel-slide-${id}`,
        id: `carousel-slide-${i}-${id}`,
        type: "radio",
        value: i,
        onChange: onSlideSelection,
        checked: selectedSlideIndex === i
      }), /*#__PURE__*/React.createElement(CarouselSelectorLabelStyle, {
        "data-element": "selector-label",
        htmlFor: `carousel-slide-${i}-${id}`
      })));
    }
    return /*#__PURE__*/React.createElement(CarouselSelectorWrapperStyle, {
      "data-element": "slide-selector"
    }, buttons);
  }
  function previousButton() {
    if (!enablePreviousButton) return null;
    const isDisabled = selectedSlideIndex === 0;
    return /*#__PURE__*/React.createElement(CarouselPreviousButtonWrapperStyle, null, /*#__PURE__*/React.createElement(CarouselButtonStyle, {
      onClick: onPreviousClick,
      "data-element": "previous",
      "aria-label": "previous",
      disabled: isDisabled
    }, /*#__PURE__*/React.createElement(CarouselStyledIconLeft, {
      type: "chevron_down"
    })));
  }
  function nextButton() {
    if (!enableNextButton) return null;
    const isDisabled = numOfSlides === selectedSlideIndex + 1;
    return /*#__PURE__*/React.createElement(CarouselNextButtonWrapperStyle, null, /*#__PURE__*/React.createElement(CarouselButtonStyle, {
      onClick: onNextClick,
      "data-element": "next",
      "aria-label": "next",
      type: "button",
      disabled: isDisabled
    }, /*#__PURE__*/React.createElement(CarouselStyledIconRight, {
      type: "chevron_down"
    })));
  }
  return /*#__PURE__*/React.createElement(CarouselWrapperStyle, _extends({
    className: className
  }, tagComponent("carousel", props)), /*#__PURE__*/React.createElement("div", {
    className: "carbon-carousel__content"
  }, previousButton(), /*#__PURE__*/React.createElement(CarouselSliderWrapper, {
    elementIndex: selectedSlideIndex
  }, children), nextButton()), slideSelector());
};
Carousel.displayName = "Carousel";
export default Carousel;