function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState } from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps } from "../../style/utils";
import CardContext from "./__internal__/card-context";
import { StyledCard, StyledCardContent } from "./card.style";
import Icon from "../icon";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
const Card = ({
  "data-element": dataElement,
  "data-role": dataRole,
  children,
  width = "500px",
  draggable,
  height,
  onClick,
  href,
  spacing = "medium",
  boxShadow,
  hoverBoxShadow,
  roundness = "default",
  footer,
  rel,
  target,
  "aria-label": ariaLabel,
  ...rest
}) => {
  const [contentRef, setContentRef] = useState(null);
  const interactive = !!(onClick || href);
  let footerWarningFired = false;
  if (!footerWarningFired && interactive && contentRef?.querySelector("[data-component='card-footer']")) {
    footerWarningFired = true;
    // eslint-disable-next-line no-console
    console.warn("This `Card` is interactive you should use the `footer` prop to render a `CardFooter` to avoid potential accessibility issues");
  }
  return /*#__PURE__*/React.createElement(StyledCard, _extends({
    cardWidth: width,
    interactive: interactive,
    draggable: !!draggable,
    spacing: spacing,
    boxShadow: boxShadow,
    hoverBoxShadow: hoverBoxShadow,
    height: height,
    roundness: roundness
  }, filterStyledSystemMarginProps(rest), tagComponent("card", {
    "data-element": dataElement,
    "data-role": dataRole
  })), draggable && /*#__PURE__*/React.createElement(Icon, {
    type: "drag"
  }), /*#__PURE__*/React.createElement(CardContext.Provider, {
    value: {
      roundness,
      spacing
    }
  }, /*#__PURE__*/React.createElement(StyledCardContent, {
    "data-element": "card-content-container",
    onClick: !draggable ? onClick : undefined,
    href: !draggable ? href : undefined,
    rel: !draggable && href ? rel : undefined,
    target: !draggable && href ? target : undefined,
    interactive: interactive,
    spacing: spacing,
    roundness: roundness,
    hasFooter: !!footer,
    ref: setContentRef,
    "aria-label": ariaLabel
  }, children), footer));
};
Card.displayName = "Card";
export default Card;