import React from "react";
import { MarginProps } from "styled-system";
import * as DesignTokens from "@sage/design-tokens/js/base/common";
import { CardContextProps } from "./__internal__/card-context";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
declare type DesignTokensType = keyof typeof DesignTokens;
declare type BoxShadowsType = Extract<DesignTokensType, `boxShadow${string}`>;
export interface CardProps extends MarginProps, Pick<TagProps, "data-element" | "data-role"> {
    /** Action to be executed when card is clicked or enter pressed.
     * Renders a button when passed and no draggable or href props set
     * */
    onClick?: (event: React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLDivElement> | React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLDivElement>) => void;
    /** Style value for width of card */
    width?: string;
    /** Child nodes */
    children: React.ReactNode;
    /** Flag to indicate if card is draggable */
    draggable?: boolean;
    /** Height of the component (any valid CSS value) */
    height?: string;
    /** Design token for custom Box Shadow. Note: please check that the box shadow design token you are using is compatible with the Card component. */
    boxShadow?: BoxShadowsType;
    /** Design token for custom Box Shadow on hover. One of `onClick` or `href` props must be true. Note: please check that the box shadow design token you are using is compatible with the Card component. */
    hoverBoxShadow?: BoxShadowsType;
    /** Size of card for applying padding */
    spacing?: CardContextProps["spacing"];
    /** Sets the level of roundness of the corners, "default" is 8px and "large" is 16px */
    roundness?: CardContextProps["roundness"];
    /** The path to navigate to. Renders an anchor element when passed and no draggable prop set */
    href?: string;
    /** The footer to render underneath the Card content */
    footer?: React.ReactNode;
    /** Target property in which link should open ie: _blank, _self, _parent, _top */
    target?: string;
    /** String for rel property when card has an href prop set */
    rel?: string;
    /** Prop to specify an aria-label for the component */
    "aria-label"?: string;
}
declare const Card: {
    ({ "data-element": dataElement, "data-role": dataRole, children, width, draggable, height, onClick, href, spacing, boxShadow, hoverBoxShadow, roundness, footer, rel, target, "aria-label": ariaLabel, ...rest }: CardProps): React.JSX.Element;
    displayName: string;
};
export default Card;
