function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useRef } from "react";
import PropTypes from "prop-types";
import { filterStyledSystemPaddingProps } from "../../../style/utils";
import StyledCardRow from "./card-row.style";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import CardContext from "../__internal__/card-context";
import guid from "../../../__internal__/utils/helpers/guid";
const CardRow = ({
  children,
  ...rest
}) => {
  const {
    spacing
  } = useContext(CardContext);
  const id = useRef(guid());
  return /*#__PURE__*/React.createElement(StyledCardRow, _extends({
    id: id.current,
    spacing: spacing
  }, filterStyledSystemPaddingProps(rest), tagComponent("card-row", {
    "data-element": "card-row",
    ...rest
  })), children);
};
CardRow.displayName = "CardRow";
export default CardRow;