function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps, filterStyledSystemPaddingProps } from "../../../style/utils";
import StyledCardFooter from "./card-footer.style";
import CardContext from "../__internal__/card-context";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
const CardFooter = ({
  children,
  variant = "default",
  ...rest
}) => {
  const {
    roundness,
    spacing
  } = useContext(CardContext);
  return /*#__PURE__*/React.createElement(StyledCardFooter, _extends({
    spacing: spacing,
    variant: variant
  }, filterStyledSystemMarginProps(rest), filterStyledSystemPaddingProps(rest), tagComponent("card-footer", {
    "data-element": "card-footer",
    ...rest
  }), {
    roundness: roundness
  }), children);
};
CardFooter.displayName = "CardFooter";
export default CardFooter;