import React, { createContext, useContext } from "react";
import PropTypes from "prop-types";
import { ThemeProvider } from "styled-components";
import CarbonScopedTokensProvider from "../../style/design-tokens/carbon-scoped-tokens-provider";
import { sageTheme } from "../../style/themes";
import { TopModalContextProvider } from "./top-modal-context";
export const NewValidationContext = /*#__PURE__*/createContext({});
export const CarbonProvider = ({
  children,
  theme = sageTheme,
  validationRedesignOptIn = false,
  roundedCornersOptOut = false,
  focusRedesignOptOut = false
}) => {
  const {
    roundedCornersOptOut: existingRoundedCornersOptOut,
    focusRedesignOptOut: existingFocusRedesignOptOut
  } = useContext(NewValidationContext);
  const roundedCornersOptOutValue = existingRoundedCornersOptOut || roundedCornersOptOut;
  const focusRedesignOptOutValue = existingFocusRedesignOptOut || focusRedesignOptOut;
  return /*#__PURE__*/React.createElement(ThemeProvider, {
    theme: {
      ...theme,
      roundedCornersOptOut: roundedCornersOptOutValue,
      focusRedesignOptOut: focusRedesignOptOutValue
    }
  }, /*#__PURE__*/React.createElement(CarbonScopedTokensProvider, null, /*#__PURE__*/React.createElement(NewValidationContext.Provider, {
    value: {
      validationRedesignOptIn,
      roundedCornersOptOut: roundedCornersOptOutValue
    }
  }, /*#__PURE__*/React.createElement(TopModalContextProvider, null, children))));
};
export default CarbonProvider;