import styled, { css } from "styled-components";
import { space } from "styled-system";
import BaseTheme from "../../style/themes/base";
import buttonTypes from "./button-types.style";
import StyledIcon from "../icon/icon.style";
import addFocusStyling from "../../style/utils/add-focus-styling";
function additionalIconStyle(iconType) {
  if (iconType === "services") return "6px";
  return "20px";
}
function stylingForIconOnly(size) {
  let dimension = "";
  switch (size) {
    case "small":
      dimension = "32px";
      break;
    case "large":
      dimension = "48px";
      break;
    default:
      dimension = "40px";
  }
  return `
  padding: 0px; 
  width: ${dimension}; 
  min-height: ${dimension}`;
}
function stylingForType({
  iconOnly,
  disabled,
  buttonType,
  size,
  destructive
}) {
  return css`
    ${buttonTypes(disabled, destructive)[buttonType]};

    ${size === "small" && css`
      font-size: var(--fontSizes100);
      min-height: 32px;
    `}

    ${size === "medium" && css`
      font-size: var(--fontSizes100);
      min-height: 40px;
    `}
    
    ${size === "large" && css`
      font-size: var(--fontSizes200);
      min-height: 48px;
    `}

    ${iconOnly && stylingForIconOnly(size)}
  `;
}
const oldFocusStyling = "outline: solid 3px var(--colorsSemanticFocus500);";
const StyledButton = styled.button`
  ${space}
  ${({
  disabled,
  noWrap,
  theme
}) => css`
    align-items: center;
    cursor: ${disabled ? "not-allowed" : "pointer"};
    display: inline-flex;
    ${noWrap ? "white-space: nowrap;" : "flex-flow: wrap;"}
    justify-content: center;
    vertical-align: middle;
    outline-offset: 0;
    border: 2px solid transparent;
    box-sizing: border-box;
    font-weight: 600;
    text-decoration: none;
    border-radius: var(--borderRadius400);

    &:focus {
      ${!theme.focusRedesignOptOut ? addFocusStyling() : /* istanbul ignore next */oldFocusStyling}
    }

    ${stylingForType}
  `}

  ${({
  fullWidth
}) => fullWidth && css`
      width: 100%;
    `}
    
  ${({
  iconOnly,
  iconPosition,
  iconType
}) => css`
    ${StyledIcon} {
      margin-left: ${!iconOnly && iconPosition === "after" ? "var(--spacing100)" : "0px"};
      margin-right: ${!iconOnly && iconPosition === "before" ? "var(--spacing100)" : "0px"};
      margin-bottom: ${iconOnly ? "1px" : "0px"};
      height: ${additionalIconStyle(iconType)};
      width: 20px;
      svg {
        margin-top: 0;
      }
      ${iconOnly && "margin-left: auto; margin-right: auto"}
    }
  `}
`;
export const StyledButtonSubtext = styled.span`
  font-size: 14px;
  font-weight: 400;
  display: block;
`;
export const StyledButtonMainText = styled.span`
  display: flex;
  align-items: center;
`;
StyledButton.defaultProps = {
  theme: BaseTheme
};
export default StyledButton;