import styled, { css } from "styled-components";
import StyledIcon from "../icon/icon.style";
import addFocusStyling from "../../style/utils/add-focus-styling";
import baseTheme from "../../style/themes/base";
export const heightConfig = {
  small: 24,
  medium: 32,
  large: 40
};
export const fontSizeConfig = {
  small: 14,
  medium: 14,
  large: 16
};
export const paddingConfig = {
  small: 8,
  medium: 8,
  large: 12
};
const heightLargeIconConfig = {
  small: 72,
  medium: 88,
  large: 120
};
const paddingLargeIconConfig = {
  small: 24,
  medium: 40,
  large: 48
};
const StyledButtonToggleContentWrapper = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  width: 100%;
  height: 100%;
  flex-flow: wrap;
`;
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledButtonToggle = styled.button`
  display: inline-flex;
  justify-content: center;
  align-items: center;
  position: relative;
  box-sizing: border-box;
  max-width: 100%;

  font-weight: 700;
  background-color: transparent;
  cursor: pointer;
  text-align: start;
  color: var(--colorsActionMinor500);
  border: none;

  ${StyledIcon} {
    color: var(--colorsActionMinor500);
  }

  ${({
  size
}) => css`
    height: ${heightConfig[size]}px;
    padding: 0 ${paddingConfig[size]}px;
    font-size: ${fontSizeConfig[size]}px;
  `}

  ${({
  buttonIcon,
  buttonIconSize,
  size
}) => buttonIcon && buttonIconSize === "large" && css`
      height: ${heightLargeIconConfig[size]}px;
      padding: 0 ${paddingLargeIconConfig[size]}px;
      flex-direction: column;
    `}  
    
  &:focus {
    ${({
  theme
}) => `${!theme.focusRedesignOptOut ? addFocusStyling() : /* istanbul ignore next */oldFocusStyling}`}
    z-index: 100;
  }

  &:not(:disabled):hover {
    background-color: var(--colorsActionMinor600);
    color: var(--colorsActionMinorYang100);
    ${StyledIcon} {
      color: var(--colorsActionMinorYang100);
    }
  }

  &[aria-pressed="true"] {
    background-color: var(--colorsActionMinor850);
    color: var(--colorsActionMinorYang100);

    ${StyledIcon} {
      color: var(--colorsActionMinorYang100);
    }

    ${({
  allowDeselect
}) => !allowDeselect && css`
        cursor: auto;
      `}
  }

  ${({
  disabled
}) => disabled && css`
      cursor: not-allowed;

      & {
        color: var(--colorsActionMinorYin030);
        ${StyledIcon} {
          color: var(--colorsActionMinorYin030);
        }
      }

      &[aria-pressed="true"] {
        cursor: not-allowed;
        background-color: var(--colorsActionMinorYin030);
      }
    `}
`;
const iconFontSizes = {
  smallIcon: 20,
  largeIcon: 32
};
const StyledButtonToggleIcon = styled.div`
  ${({
  hasContent
}) => hasContent && `margin-right: 8px;`}
  ${({
  buttonIconSize
}) => buttonIconSize === "large" && css`
      margin-right: 0;
      ${StyledIcon} {
        margin-left: 0;
        margin-right: 0;
        margin-bottom: 8px;
        height: ${`${iconFontSizes.largeIcon}px`};
        width: ${`${iconFontSizes.largeIcon}px`};
      }
      ${StyledIcon}::before {
        font-size: ${`${iconFontSizes[`${buttonIconSize}Icon`]}px`};
        line-height: ${`${iconFontSizes[`${buttonIconSize}Icon`]}px`};
      }
      .carbon-icon__svg--credit-card-slash {
        margin-left: 6px;
      }
    `}
`;
StyledButtonToggle.defaultProps = {
  theme: baseTheme
};
const StyledButtonToggleWrapper = styled.div`
  display: inline-block;
  vertical-align: middle;

  ${({
  grouped
}) => css`
      ${!grouped && css`
        &&&& {
          ${StyledButtonToggle} {
            border-radius: var(--borderRadius050);
          }
        }
      `}

      ${grouped && css`
        &&&& {
          :first-of-type {
            ${StyledButtonToggle} {
              border-top-left-radius: var(--borderRadius050);
              border-bottom-left-radius: var(--borderRadius050);
            }
          }

          :last-of-type {
            ${StyledButtonToggle} {
              border-top-right-radius: var(--borderRadius050);
              border-bottom-right-radius: var(--borderRadius050);
            }
          }
        }
      `}
    `}

  ${({
  grouped
}) => grouped && css`
      &:not(:first-of-type) {
        margin-left: -1px;
      }
    `};
`;
export { StyledButtonToggle, StyledButtonToggleWrapper, StyledButtonToggleIcon, StyledButtonToggleContentWrapper };