function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useRef } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { StyledButtonToggle, StyledButtonToggleWrapper } from "./button-toggle.style";
import guid from "../../__internal__/utils/helpers/guid";
import { ButtonToggleGroupContext } from "./button-toggle-group/button-toggle-group.component";
import ButtonToggleIcon from "./button-toggle-icon.component";
import Logger from "../../__internal__/utils/logger";
import { InputGroupContext } from "../../__internal__/input-behaviour";
let deprecateCheckedWarnTriggered = false;
let deprecateNameWarnTriggered = false;
let deprecateUncontrolledWarnTriggered = false;
let deprecateGroupedWarnTriggered = false;
export const ButtonToggle = ({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  buttonIcon,
  buttonIconSize = "small",
  checked,
  children,
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  disabled,
  grouped,
  name,
  onBlur,
  onFocus,
  onClick,
  pressed,
  size = "medium",
  value
}) => {
  !!!(children || buttonIcon) ? process.env.NODE_ENV !== "production" ? invariant(false, "Either prop `buttonIcon` must be defined, or this node must have children") : invariant(false) : void 0;
  if (checked !== undefined && !deprecateCheckedWarnTriggered) {
    deprecateCheckedWarnTriggered = true;
    Logger.deprecate("The `checked` prop in `ButtonToggle` component is deprecated and will soon be removed. Please use `pressed` instead.");
  }
  if (name && !deprecateNameWarnTriggered) {
    deprecateNameWarnTriggered = true;
    Logger.deprecate(`The \`name\` prop in \`ButtonToggle\` component is deprecated and will soon be removed. It does not provide any functionality
      since the component can no longer be used in an uncontrolled fashion.`);
  }
  if (grouped && !deprecateGroupedWarnTriggered) {
    deprecateGroupedWarnTriggered = true;
    Logger.deprecate("The `grouped` prop in `ButtonToggle` component is deprecated and will soon be removed. Spacing between buttons is no longer no removed.");
  }
  const pressedPropValue = pressed === undefined ? checked : pressed;
  const buttonRef = useRef(null);
  const {
    onMouseEnter,
    onMouseLeave,
    onBlur: inputGroupOnBlur,
    onFocus: inputGroupOnFocus
  } = useContext(InputGroupContext);
  const {
    onButtonClick,
    handleKeyDown,
    pressedButtonValue,
    onChange,
    name: groupName,
    allowDeselect,
    isInGroup,
    isDisabled,
    firstButton,
    childButtonCallbackRef,
    hintTextId
  } = useContext(ButtonToggleGroupContext);
  const callbackRef = element => {
    buttonRef.current = element;
    if (childButtonCallbackRef) {
      childButtonCallbackRef(element);
    }
  };
  const inputGuid = useRef(guid());
  function handleClick(ev) {
    if (onClick) {
      onClick(ev);
    }
    if (onChange) {
      let newValue = value;
      if (allowDeselect && pressedButtonValue === value) {
        newValue = undefined;
      }
      onChange(ev, newValue, groupName || name);
    }
    if (value) {
      onButtonClick(value);
    }
  }
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Button Toggle` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  function handleFocus(ev) {
    if (onFocus) {
      onFocus(ev);
    }
    if (inputGroupOnFocus) {
      inputGroupOnFocus();
    }
  }
  function handleBlur(ev) {
    if (onBlur) {
      onBlur(ev);
    }
    if (inputGroupOnBlur) {
      inputGroupOnBlur();
    }
  }
  const isPressed = isInGroup ? pressedButtonValue === value : pressedPropValue;
  const isFirstButton = buttonRef.current === firstButton;

  // if we're in a ButtonToggleGroup, only one button should be tabbable - the pressed button if there is one, or
  // the first one if not
  const tabbable = !isInGroup || isPressed || !pressedButtonValue && isFirstButton;
  return /*#__PURE__*/React.createElement(StyledButtonToggleWrapper, {
    "data-component": dataComponent || "button-toggle",
    "data-element": dataElement,
    "data-role": dataRole,
    grouped: grouped
  }, /*#__PURE__*/React.createElement(StyledButtonToggle, _extends({
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    "aria-describedby": hintTextId || undefined,
    "aria-pressed": !!isPressed,
    buttonIcon: buttonIcon,
    buttonIconSize: buttonIconSize,
    "data-element": "button-toggle-button",
    disabled: disabled || isDisabled,
    id: inputGuid.current,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    size: size,
    grouped: grouped,
    value: value,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onClick: handleClick,
    onKeyDown: handleKeyDown
    // In Safari non-text input elements do not gain focus on click. To get around this, we have to apply a tab-index of 0 here.
    // This is to allow the ButtonToggle component to be focused when it is the first tabbable element.
  }, tabbable ? {
    tabIndex: 0
  } : {
    tabIndex: -1
  }, {
    allowDeselect: allowDeselect,
    ref: callbackRef
  }), buttonIcon && /*#__PURE__*/React.createElement(ButtonToggleIcon, {
    buttonIcon: buttonIcon,
    buttonIconSize: buttonIconSize,
    disabled: disabled,
    hasContent: !!children
  }), children));
};
ButtonToggle.displayName = "ButtonToggle";
export default ButtonToggle;