import React from "react";
import { StyledButtonToggleProps } from "./button-toggle.style";
export interface ButtonToggleProps extends Partial<StyledButtonToggleProps> {
    /** Prop to specify the aria-label of the component */
    "aria-label"?: string;
    /** Prop to specify the aria-labelledby property of the component */
    "aria-labelledby"?: string;
    /** DEPRECATED: A synonym for pressed, to keep backwards compatibility. */
    checked?: boolean;
    /** Text to display for the button. */
    children?: React.ReactNode;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** DEPRECATED: Remove spacing from between buttons. */
    grouped?: boolean;
    /** An optional string by which to identify the button in an onChange handler on the parent ButtonToggleGroup. */
    name?: string;
    /** Callback triggered by blur event on the button. */
    onBlur?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Callback triggered by focus event on the button. */
    onFocus?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Callback triggered by click event on the button. */
    onClick?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    /** Set the pressed state of the toggle button */
    pressed?: boolean;
    /** An optional string by which to identify the button in either an onClick handler, or an onChange handler on the parent ButtonToggleGroup. */
    value?: string;
}
export declare const ButtonToggle: {
    ({ "aria-label": ariaLabel, "aria-labelledby": ariaLabelledBy, buttonIcon, buttonIconSize, checked, children, "data-component": dataComponent, "data-element": dataElement, "data-role": dataRole, disabled, grouped, name, onBlur, onFocus, onClick, pressed, size, value, }: ButtonToggleProps): React.JSX.Element;
    displayName: string;
};
export default ButtonToggle;
