import styled, { css } from "styled-components";
import { margin } from "styled-system";
import { baseTheme } from "../../../style/themes";
import { StyledButtonToggle, StyledButtonToggleWrapper } from "../button-toggle.style";
const StyledButtonToggleGroup = styled.div`
  ${margin}

  display: flex;
  box-shadow: inset 0px 0px 0px 1px var(--colorsActionMinor500);
  border-radius: var(--borderRadius100);
  padding: 4px;
  gap: 4px;
  width: fit-content;
  height: fit-content;
  flex-wrap: wrap;

  ${({
  disabled
}) => disabled && css`
      cursor: not-allowed;
      box-shadow: inset 0px 0px 0px 1px var(--colorsActionDisabled600);
    `}

  ${({
  fullWidth
}) => fullWidth && css`
      width: 100%;
      ${StyledButtonToggle} {
        width: 100%;
      }
      ${StyledButtonToggleWrapper} {
        flex: auto;
      }
    `}

  ${({
  inputWidth
}) => inputWidth && css`
      width: ${`${inputWidth}%`};
    `}
`;
export const StyledButtonToggleGroupWrapper = styled.div`
  ${({
  labelInline
}) => labelInline && css`
      display: flex;
      ${StyledButtonToggleGroup} {
        flex-wrap: nowrap;
      }
    `}
`;
export const StyledHintText = styled.div`
  ::after {
    content: " ";
  }

  margin-top: var(--spacing000);
  margin-bottom: var(--spacing150);
  color: ${({
  isDisabled
}) => isDisabled ? "var(--colorsUtilityYin030)" : "var(--colorsUtilityYin055)"};
  font-size: 14px;
`;
StyledButtonToggleGroup.defaultProps = {
  theme: baseTheme
};
export default StyledButtonToggleGroup;