function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { createContext, useMemo, useState, useRef, useContext } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import FormField from "../../../__internal__/form-field";
import guid from "../../../__internal__/utils/helpers/guid";
import StyledButtonToggleGroup, { StyledButtonToggleGroupWrapper, StyledHintText } from "./button-toggle-group.style";
import { ButtonToggle } from "..";
import { filterStyledSystemMarginProps } from "../../../style/utils";
import { TooltipProvider } from "../../../__internal__/tooltip-provider";
import { InputGroupBehaviour } from "../../../__internal__/input-behaviour";
import Logger from "../../../__internal__/utils/logger";
import Events from "../../../__internal__/utils/helpers/events";
import { NewValidationContext } from "../../carbon-provider/carbon-provider.component";
let deprecateNameWarnTriggered = false;
const BUTTON_TOGGLE_SELECTOR = '[data-element="button-toggle-button"]';
export const ButtonToggleGroupContext = /*#__PURE__*/createContext({
  onButtonClick: /* istanbul ignore next */() => {},
  handleKeyDown: /* istanbul ignore next */() => {},
  pressedButtonValue: undefined,
  allowDeselect: false,
  isInGroup: false,
  isDisabled: false
});
const ButtonToggleGroup = ({
  children,
  fieldHelp,
  fieldHelpInline,
  "aria-label": ariaLabel,
  label,
  labelHelp,
  labelSpacing,
  inputHint,
  inputWidth,
  fullWidth,
  labelInline,
  labelWidth,
  name,
  onChange,
  value,
  "data-component": dataComponent = "button-toggle-group",
  "data-element": dataElement,
  "data-role": dataRole,
  helpAriaLabel,
  id,
  allowDeselect,
  disabled,
  className,
  ...props
}) => {
  const hasCorrectItemStructure = useMemo(() => {
    const incorrectChild = React.Children.toArray(children).find(child => {
      return ! /*#__PURE__*/React.isValidElement(child) || child.type.displayName !== ButtonToggle.displayName;
    });
    return !incorrectChild;
  }, [children]);
  !hasCorrectItemStructure ? process.env.NODE_ENV !== "production" ? invariant(false, `\`ButtonToggleGroup\` only accepts children of type \`${ButtonToggle.displayName}\``) : invariant(false) : void 0;
  const labelId = useRef(guid());
  const hintTextId = useRef(guid());
  const wrapperRef = useRef(null);
  const [pressedButtonValue, setPressedButtonValue] = useState();
  if (name && !deprecateNameWarnTriggered) {
    deprecateNameWarnTriggered = true;
    Logger.deprecate(`The \`name\` prop in \`ButtonToggleGroup\` component is deprecated and will soon be removed. It does not provide any functionality
      since the component can no longer be used in an uncontrolled fashion.`);
  }
  const {
    validationRedesignOptIn
  } = useContext(NewValidationContext);
  const computeLabelPropValues = prop => validationRedesignOptIn ? undefined : prop;
  const onButtonClick = buttonValue => {
    let newValue = buttonValue;
    const currentValue = value || pressedButtonValue;
    if (allowDeselect && currentValue === buttonValue) {
      newValue = undefined;
    }
    setPressedButtonValue(newValue);
  };
  const getInnerButtons = () => wrapperRef.current?.querySelectorAll(BUTTON_TOGGLE_SELECTOR);
  // needs to be state not ref, so that a rerender is triggered
  const [firstButton, setFirstButton] = useState();
  const handleKeyDown = ev => {
    const innerButtons = getInnerButtons();
    // istanbul ignore if
    if (!innerButtons || !document.activeElement) {
      return;
    }
    const focusedIndex = Array.from(innerButtons).indexOf(document.activeElement);
    let nextElement;
    if (Events.isLeftKey(ev)) {
      const nextIndex = focusedIndex === 0 ? innerButtons.length - 1 : focusedIndex - 1;
      nextElement = innerButtons[nextIndex];
    } else if (Events.isRightKey(ev)) {
      const nextIndex = (focusedIndex + 1) % innerButtons.length;
      nextElement = innerButtons[nextIndex];
    }
    // istanbul ignore else
    if (nextElement instanceof HTMLButtonElement) {
      nextElement.focus();
    }
  };
  const childButtonCallbackRef = button => {
    // setTimeout needed as otherwise innerButtons aren't picked up by the query even though the ref is attached
    setTimeout(() => {
      // guard needed to avoid warnings about setting state on an unmounted component - the callback ref will
      // get called with null when the component is about to be unmounted, and it has been unmounted by the time
      // the setTimeout completes
      /* istanbul ignore else */
      if (button) {
        const innerButtons = getInnerButtons();
        /* istanbul ignore if */
        if (!innerButtons) {
          setFirstButton(undefined);
        } else if (button === innerButtons[0]) {
          setFirstButton(button);
        }
      }
    }, 0);
  };
  return /*#__PURE__*/React.createElement(TooltipProvider, {
    helpAriaLabel: helpAriaLabel
  }, /*#__PURE__*/React.createElement(InputGroupBehaviour, null, /*#__PURE__*/React.createElement(FormField, _extends({
    label: label,
    labelHelp: computeLabelPropValues(labelHelp),
    labelSpacing: computeLabelPropValues(labelSpacing),
    fieldHelp: computeLabelPropValues(fieldHelp),
    fieldHelpInline: computeLabelPropValues(fieldHelpInline),
    labelInline: computeLabelPropValues(labelInline),
    labelWidth: computeLabelPropValues(labelWidth),
    labelId: labelId.current,
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    id: id,
    labelAs: "span",
    disabled: disabled
  }, filterStyledSystemMarginProps(props)), /*#__PURE__*/React.createElement(ButtonToggleGroupContext.Provider, {
    value: {
      onButtonClick,
      handleKeyDown,
      pressedButtonValue: value || pressedButtonValue,
      onChange,
      name,
      allowDeselect,
      isInGroup: true,
      isDisabled: disabled,
      firstButton,
      childButtonCallbackRef,
      hintTextId: inputHint ? hintTextId.current : undefined
    }
  }, inputHint && /*#__PURE__*/React.createElement(StyledHintText, {
    id: hintTextId.current,
    isDisabled: disabled
  }, inputHint), /*#__PURE__*/React.createElement(StyledButtonToggleGroupWrapper, {
    labelInline: labelInline,
    ref: wrapperRef
  }, /*#__PURE__*/React.createElement(StyledButtonToggleGroup, _extends({}, label ? {
    "aria-labelledby": labelId.current
  } : {
    "aria-label": ariaLabel
  }, {
    inputWidth: inputWidth,
    fullWidth: fullWidth,
    role: "group",
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    id: id,
    className: className,
    disabled: disabled
  }), children))))));
};
ButtonToggleGroup.displayName = "ButtonToggleGroup";
export default ButtonToggleGroup;