function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import StyledButtonMinor from "./button-minor.style";
import { ButtonBarContext } from "../button-bar/button-bar.component";
const ButtonMinor = /*#__PURE__*/React.forwardRef(({
  buttonType: buttonTypeProp = "secondary",
  disabled = false,
  destructive = false,
  size: sizeProp = "medium",
  iconPosition: iconPositionProp = "before",
  fullWidth: fullWidthProp = false,
  ...rest
}, ref) => {
  const {
    buttonType: buttonTypeContext,
    size: sizeContext,
    iconPosition: iconPositionContext,
    fullWidth: fullWidthContext
  } = useContext(ButtonBarContext);
  const buttonType = buttonTypeContext || buttonTypeProp;
  const size = sizeContext || sizeProp;
  const iconPosition = iconPositionContext || iconPositionProp;
  const fullWidth = fullWidthContext || fullWidthProp;
  return /*#__PURE__*/React.createElement(StyledButtonMinor, _extends({
    ref: ref,
    "data-component": "button-minor",
    size: size,
    fullWidth: fullWidth,
    iconPosition: iconPosition,
    buttonType: buttonType,
    disabled: disabled,
    destructive: destructive
  }, rest));
});

export { ButtonMinor };
ButtonMinor.displayName = "ButtonMinor";
export default ButtonMinor;