function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import StyledButtonBar from "./button-bar.style";
export const ButtonBarContext = /*#__PURE__*/React.createContext({});
export const ButtonBar = ({
  children,
  size = "medium",
  iconPosition = "before",
  fullWidth = false,
  ...rest
}) => /*#__PURE__*/React.createElement(StyledButtonBar, _extends({}, rest, {
  fullWidth: fullWidth,
  size: size
}), /*#__PURE__*/React.createElement(ButtonBarContext.Provider, {
  value: {
    buttonType: "secondary",
    size,
    iconPosition,
    fullWidth
  }
}, children));
ButtonBar.displayName = "ButtonBar";
export default ButtonBar;