import React from "react";
import { SpaceProps } from "styled-system";
export interface ButtonBarContextProps {
    /** Apply fullWidth style to the button bar */
    fullWidth?: boolean;
    /** Defines an Icon position for buttons: "before" | "after" */
    iconPosition?: "before" | "after";
    /** Assigns a size to the buttons: "small" | "medium" | "large" */
    size?: "small" | "medium" | "large";
    /** Color variants for new business themes: "primary" | "secondary" | "tertiary" | "darkBackground" */
    buttonType?: "primary" | "secondary" | "primary";
}
export interface ButtonBarProps extends ButtonBarContextProps, SpaceProps {
    /** Button or IconButton Elements, to be rendered inside the component */
    children: React.ReactNode;
}
export declare const ButtonBarContext: React.Context<ButtonBarContextProps>;
export declare const ButtonBar: {
    ({ children, size, iconPosition, fullWidth, ...rest }: ButtonBarProps): React.JSX.Element;
    displayName: string;
};
export default ButtonBar;
