function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags";
import { StyledCrumb, Divider } from "./crumb.style";
const Crumb = /*#__PURE__*/React.forwardRef(({
  href,
  isCurrent,
  children,
  onClick,
  ...rest
}, ref) => /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(StyledCrumb, _extends({
  ref: ref,
  isCurrent: isCurrent,
  "aria-current": isCurrent ? "page" : undefined
}, tagComponent("crumb", rest), rest, !isCurrent && {
  href,
  onClick
}), children), !isCurrent && /*#__PURE__*/React.createElement(Divider, null)));
if (process.env.NODE_ENV !== "production") {
  Crumb.propTypes = {
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "children": PropTypes.node,
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "hasFocus": PropTypes.bool,
    "href": PropTypes.string,
    "isCurrent": PropTypes.bool,
    "onClick": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "placeholderTabIndex": PropTypes.bool,
    "removeAriaLabelOnIcon": PropTypes.bool
  };
}
Crumb.displayName = "Crumb";
export default Crumb;