function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags";
import StyledBreadcrumbs from "./breadcrumbs.style";
import useLocale from "../../hooks/__internal__/useLocale";
const Breadcrumbs = /*#__PURE__*/React.forwardRef(({
  children,
  ...rest
}, ref) => {
  const l = useLocale();
  return /*#__PURE__*/React.createElement(StyledBreadcrumbs, _extends({
    ref: ref,
    role: "navigation"
  }, tagComponent("breadcrumbs", rest), {
    "aria-label": l.breadcrumbs.ariaLabel()
  }, rest), /*#__PURE__*/React.createElement("ol", null, children));
});
if (process.env.NODE_ENV !== "production") {
  Breadcrumbs.propTypes = {
    "children": PropTypes.node,
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "p": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "padding": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pl": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "px": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "py": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])
  };
}
export { Breadcrumbs };
Breadcrumbs.displayName = "Breadcrumbs";
export default Breadcrumbs;