import React from "react";
import { SpaceProps, LayoutProps, FlexboxProps, PositionProps, GridProps } from "styled-system";
import * as DesignTokens from "@sage/design-tokens/js/base/common";
import { Gap } from "style/utils/box-gap";
import { TagProps } from "../../__internal__/utils/helpers/tags";
export declare type OverflowWrap = "break-word" | "anywhere";
export declare type ScrollVariant = "light" | "dark";
export declare type BoxSizing = "content-box" | "border-box";
declare type DesignTokensType = keyof typeof DesignTokens;
declare type BoxShadowsType = Extract<DesignTokensType, `boxShadow${string}`>;
export declare type BorderRadiusType = Extract<DesignTokensType, `borderRadius${string}`>;
export interface BoxProps extends FlexboxProps, Omit<GridProps, "gridGap" | "gridRowGap" | "gridColumnGap">, LayoutProps, Omit<PositionProps, "zIndex">, SpaceProps, TagProps {
    as?: keyof JSX.IntrinsicElements | React.ComponentType<any>;
    /** Set the ID attribute of the Box component */
    id?: string;
    /** Content to be rendered inside the Box component */
    children?: React.ReactNode;
    /** Set the Role attribute of the Box component */
    role?: string;
    /** String to set Box content break strategy. Note "anywhere" is not supported in Safari */
    overflowWrap?: OverflowWrap;
    /** Scroll styling attribute */
    scrollVariant?: ScrollVariant;
    /** Set the box-sizing attribute of the Box component */
    boxSizing?: BoxSizing;
    /** Allows a tabindex to be specified */
    tabIndex?: number;
    /** Gap, an integer multiplier of the base spacing constant (8px) or any valid CSS string." */
    gap?: Gap;
    /** Column gap, an integer multiplier of the base spacing constant (8px) or any valid CSS string." */
    columnGap?: Gap;
    /** Row gap an integer multiplier of the base spacing constant (8px) or any valid CSS string." */
    rowGap?: Gap;
    /** Design Token for Box Shadow. Note: please check that the box shadow design token you are using is compatible with the Box component. */
    boxShadow?: BoxShadowsType;
    /** Design Token for Border Radius. Note: please check that the border radius design token you are using is compatible with the Box component. **This prop will not do anything if you have the roundedCornerOptOut flag set in the CarbonProvider** */
    borderRadius?: BorderRadiusType;
    /** @private @ignore */
    className?: string;
    /** Set the color attribute of the Box component */
    color?: string;
    /** Set the bg attribute of the Box component */
    bg?: string;
    /** Set the backgroundColor attribute of the Box component */
    backgroundColor?: string;
    /** Set the opacity attribute of the Box component */
    opacity?: string | number;
    /** Set the container to be hidden from screen readers */
    "aria-hidden"?: "true" | "false";
}
export declare const Box: React.ForwardRefExoticComponent<BoxProps & React.RefAttributes<HTMLDivElement>>;
export default Box;
