import React from "react";
import PropTypes from "prop-types";
import useLocale from "../../hooks/__internal__/useLocale";
import { StyledBatchSelection, StyledSelectionCount } from "./batch-selection.style";
export const BatchSelection = ({
  disabled,
  children,
  colorTheme = "transparent",
  selectedCount,
  hidden
}) => {
  const l = useLocale();
  return /*#__PURE__*/React.createElement(StyledBatchSelection, {
    colorTheme: colorTheme,
    "data-component": "batch-selection",
    disabled: disabled,
    hidden: hidden
  }, /*#__PURE__*/React.createElement(StyledSelectionCount, {
    "data-element": "selection-count"
  }, l.batchSelection.selected(selectedCount)), children);
};
export default BatchSelection;