function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { StyledBadgeWrapper, StyledCrossIcon, StyledCounter, StyledBadge } from "./badge.style";
export const Badge = ({
  "aria-label": ariaLabel,
  children,
  counter = 0,
  color = "--colorsActionMajor500",
  onClick
}) => {
  const shouldDisplayCounter = counter > 0;
  const counterToDisplay = counter > 99 ? 99 : counter;
  const renderCorrectBadge = () => {
    const props = onClick ? {
      buttonType: "secondary",
      onClick
    } : {
      "aria-label": ariaLabel
    };
    if (shouldDisplayCounter) {
      return /*#__PURE__*/React.createElement(StyledBadge, _extends({
        "data-component": "badge",
        color: color
      }, props), onClick && /*#__PURE__*/React.createElement(StyledCrossIcon, {
        "data-element": "badge-cross-icon",
        type: "cross"
      }), /*#__PURE__*/React.createElement(StyledCounter, {
        "data-element": "badge-counter"
      }, counterToDisplay));
    }
    return null;
  };
  return /*#__PURE__*/React.createElement(StyledBadgeWrapper, null, renderCorrectBadge(), children);
};
export default Badge;