import React from "react";
export interface BadgeProps {
    /** Prop to specify an aria-label for the component */
    "aria-label"?: string;
    /** The badge will be added to this element */
    children: React.ReactNode;
    /** The number rendered in the badge component */
    counter?: string | number;
    /** Prop to specify the colour of the component */
    color?: string;
    /** Callback fired when badge is clicked */
    onClick?: (ev: React.MouseEvent<HTMLElement>) => void;
}
export declare const Badge: ({ "aria-label": ariaLabel, children, counter, color, onClick, }: BadgeProps) => React.JSX.Element;
export default Badge;
