import React from "react";
import PropTypes from "prop-types";
import StyledNavigationItem from "./anchor-navigation-item.style";
const AnchorNavigationItem = /*#__PURE__*/React.forwardRef(({
  children,
  onKeyDown,
  onClick,
  href,
  tabIndex,
  isSelected
}, ref) => /*#__PURE__*/React.createElement(StyledNavigationItem, {
  isSelected: isSelected
}, /*#__PURE__*/React.createElement("a", {
  onKeyDown: onKeyDown,
  onClick: onClick,
  tabIndex: tabIndex,
  ref: ref,
  href: href,
  "data-element": "anchor-navigation-item"
}, children)));
if (process.env.NODE_ENV !== "production") {
  AnchorNavigationItem.propTypes = {
    "children": PropTypes.node,
    "href": PropTypes.string,
    "isSelected": PropTypes.bool,
    "onClick": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "tabIndex": PropTypes.number,
    "target": PropTypes.shape({
      "current": PropTypes.oneOfType([PropTypes.oneOf([null]), function (props, propName) {
        if (props[propName] == null) {
          return new Error("Prop '" + propName + "' is required but wasn't specified");
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }]).isRequired
    })
  };
}
AnchorNavigationItem.displayName = "AnchorNavigationItem";
export default AnchorNavigationItem;