import React from "react";
export interface AnchorNavigationItemProps {
    /** Reference to the section html element meant to be shown   */
    target?: React.RefObject<HTMLElement>;
    /** href to be passed to the anchor element, can be linked with id passed to the scrollable section */
    href?: string;
    /** Indicates if component is selected */
    isSelected?: boolean;
    /** onClick handler */
    onClick?: (ev: React.MouseEvent<HTMLAnchorElement>) => void;
    /** OnKeyDown handler */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLAnchorElement>) => void;
    /** tabIndex passed to the anchor element */
    tabIndex?: number;
    /** Children elements */
    children?: React.ReactNode;
}
declare const AnchorNavigationItem: React.ForwardRefExoticComponent<AnchorNavigationItemProps & React.RefAttributes<HTMLAnchorElement>>;
export default AnchorNavigationItem;
