function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useEffect, useCallback, useRef } from "react";
import PropTypes from "prop-types";
import { StyledAdvancedColorPickerWrapper, HiddenCurrentColorList, StyledAdvancedColorPickerCell, StyledAdvancedColorPickerPreview, DialogStyle } from "./advanced-color-picker.style";
import { SimpleColorPicker, SimpleColor } from "../simple-color-picker";
import Events from "../../__internal__/utils/helpers/events";
import { filterStyledSystemMarginProps } from "../../style/utils";
import guid from "../../__internal__/utils/helpers/guid";
import useLocale from "../../hooks/__internal__/useLocale";
import { Dt, Dd } from "../definition-list";
import Logger from "../../__internal__/utils/logger";
let deprecateUncontrolledWarnTriggered = false;
export const AdvancedColorPicker = ({
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  availableColors,
  defaultColor,
  name,
  onOpen,
  onClose,
  onChange,
  onBlur,
  open = false,
  role,
  selectedColor,
  ...props
}) => {
  const [dialogOpen, setDialogOpen] = useState();
  const currentColor = selectedColor || defaultColor;
  const [selectedColorRef, setSelectedColorRef] = useState(null);
  const descriptionId = useRef(guid());
  const l = useLocale();
  const simpleColorPickerData = useRef(null);
  const colors = availableColors.map(({
    value,
    label
  }, index) => {
    return {
      value,
      label,
      getRef: () => /* Fallback to null to satisfy the TypeScript compiler */
      /* istanbul ignore next */
      simpleColorPickerData.current ? simpleColorPickerData.current.gridItemRefs[index] : null
    };
  });
  const currentSelectedColor = () => {
    const returnedColor = availableColors.find(color => color.value === currentColor)?.label;
    return returnedColor || currentColor;
  };
  useEffect(() => {
    if (dialogOpen || open) {
      const newColor = colors?.find(c => currentColor === c.value);

      /* istanbul ignore else */
      if (newColor) {
        setSelectedColorRef(newColor.getRef());
      }
    }
  }, [colors, currentColor, dialogOpen, open]);
  const handleFocus = useCallback((e, firstFocusableElement) => {
    /* istanbul ignore else */
    if (e.key === "Tab") {
      if (e.shiftKey) {
        if (document.activeElement === firstFocusableElement && selectedColorRef) {
          selectedColorRef.focus();
          e.preventDefault();
        }
      } else if (document.activeElement === selectedColorRef) {
        firstFocusableElement.focus();
        e.preventDefault();
      }
    }
  }, [selectedColorRef]);
  const handleOnOpen = useCallback(e => {
    setDialogOpen(true);
    if (onOpen) {
      onOpen(e);
    }
  }, [onOpen]);
  const handleOnClose = useCallback(e => {
    setDialogOpen(false);
    if (onClose) {
      onClose(e);
    }
  }, [onClose]);
  const handleOnChange = useCallback(e => {
    const newColor = colors?.find(c => e.target.value === c.value);

    /* istanbul ignore else */
    if (newColor) {
      setSelectedColorRef(newColor.getRef());
    }

    /* istanbul ignore else */
    if (onChange) {
      onChange(e);
    }
  }, [onChange, colors]);
  const handleOnKeyDown = useCallback(e => {
    if (Events.isEnterKey(e) || Events.isSpaceKey(e)) {
      e.preventDefault();
      handleOnOpen(e);
    }
  }, [handleOnOpen]);
  const handleColorOnKeyDown = useCallback(e => {
    if (Events.isEnterKey(e) || Events.isSpaceKey(e)) {
      e.preventDefault();
      handleOnClose(e);
    }
  }, [handleOnClose]);
  const handleOnBlur = useCallback(e => {
    if (onBlur) {
      onBlur(e);
    }
  }, [onBlur]);
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Advanced Color Picker` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/React.createElement(StyledAdvancedColorPickerWrapper, _extends({
    m: "15px auto auto 15px"
  }, filterStyledSystemMarginProps(props)), /*#__PURE__*/React.createElement(StyledAdvancedColorPickerCell, {
    "data-element": "color-picker-cell",
    "aria-label": l.advancedColorPicker.ariaLabel(),
    "aria-describedby": descriptionId.current,
    onClick: handleOnOpen,
    onKeyDown: handleOnKeyDown,
    color: currentColor,
    tabIndex: 0
  }), /*#__PURE__*/React.createElement(HiddenCurrentColorList, {
    id: descriptionId.current,
    "data-element": "current-color-description"
  }, /*#__PURE__*/React.createElement(Dt, null, l.advancedColorPicker.currentColorDescriptionTerm(currentSelectedColor())), /*#__PURE__*/React.createElement(Dd, null, l.advancedColorPicker.currentColorAssigned(currentSelectedColor()))), /*#__PURE__*/React.createElement(DialogStyle, {
    "aria-describedby": ariaDescribedBy,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    open: dialogOpen || open,
    size: "auto",
    onCancel: handleOnClose,
    bespokeFocusTrap: handleFocus,
    focusFirstElement: selectedColorRef,
    role: role
  }, /*#__PURE__*/React.createElement(StyledAdvancedColorPickerPreview, {
    "data-element": "color-picker-preview",
    color: currentColor
  }), /*#__PURE__*/React.createElement(SimpleColorPicker, {
    name: name,
    legend: "",
    onChange: handleOnChange,
    onBlur: handleOnBlur,
    onKeyDown: handleColorOnKeyDown,
    ref: simpleColorPickerData
  }, colors?.map(({
    value,
    label
  }) => /*#__PURE__*/React.createElement(SimpleColor, {
    value: value,
    key: value,
    "aria-label": label,
    id: value,
    defaultChecked: value === currentColor
  })))));
};
export default AdvancedColorPicker;