function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useCallback, useMemo, useEffect, useRef } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { MenuButton, ButtonIcon, StyledButtonIcon } from "./action-popover.style";
import Events from "../../__internal__/utils/helpers/events";
import Popover from "../../__internal__/popover";
import createGuid from "../../__internal__/utils/helpers/guid";
import useLocale from "../../hooks/__internal__/useLocale";
import ActionPopoverMenu from "./action-popover-menu/action-popover-menu.component";
import ActionPopoverItem from "./action-popover-item/action-popover-item.component";
import ActionPopoverDivider from "./action-popover-divider/action-popover-divider.component";
import ActionPopoverContext from "./action-popover-context";
import useModalManager from "../../hooks/__internal__/useModalManager";
const onOpenDefault = () => {};
const onCloseDefault = () => {};
export const ActionPopover = ({
  children,
  id,
  onOpen = onOpenDefault,
  onClose = onCloseDefault,
  rightAlignMenu,
  renderButton,
  placement = "bottom",
  horizontalAlignment = "left",
  submenuPosition = "left",
  "aria-label": ariaLabel,
  ...rest
}) => {
  const l = useLocale();
  const [isOpen, setOpenState] = useState(false);
  const [focusIndex, setFocusIndex] = useState(0);
  const [guid] = useState(createGuid());
  const buttonRef = useRef(null);
  const menu = useRef(null);
  const itemCount = useMemo(() => {
    return React.Children.toArray(children).filter(child => {
      return /*#__PURE__*/React.isValidElement(child) && child.type === ActionPopoverItem;
    }).length;
  }, [children]);
  const hasProperChildren = useMemo(() => {
    const incorrectChild = React.Children.toArray(children).find(child => {
      if (! /*#__PURE__*/React.isValidElement(child)) {
        return true;
      }
      return child.type !== ActionPopoverItem && child.type !== ActionPopoverDivider;
    });
    return !incorrectChild;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? invariant(false, `ActionPopover only accepts children of type \`${ActionPopoverItem.displayName}\`` + ` and \`${ActionPopoverDivider.displayName}\`.`) : invariant(false) : void 0;
  const mappedPlacement = useMemo(() => {
    if (placement === "top" && !rightAlignMenu) {
      return "top-end";
    }
    if (placement === "top" && rightAlignMenu) {
      return "top-start";
    }
    if (placement === "bottom" && rightAlignMenu) {
      return "bottom-start";
    }
    return "bottom-end";
  }, [placement, rightAlignMenu]);
  const setOpen = useCallback(value => {
    if (value && !isOpen) {
      onOpen();
    }
    if (!value && isOpen) {
      onClose();
    }
    setOpenState(value);
  }, [isOpen, onOpen, onClose]);
  const focusButton = useCallback(() => {
    const button = buttonRef.current?.querySelector("[data-element='action-popover-button']");
    button?.focus();
  }, []);
  const onButtonClick = useCallback(e => {
    e.stopPropagation();
    const isOpening = !isOpen;
    setOpen(isOpening);
    if (!isOpening) {
      // Closing the menu should focus the MenuButton
      focusButton();
    }
  }, [isOpen, setOpen, focusButton]);

  // Keyboard commands implemented as recommended by WAI-ARIA best practices
  // https://www.w3.org/TR/wai-aria-practices/examples/menu-button/menu-button-actions.html

  const onButtonKeyDown = useCallback(e => {
    if (Events.isSpaceKey(e) || Events.isDownKey(e) || Events.isEnterKey(e)) {
      e.preventDefault();
      e.stopPropagation();
      setFocusIndex(0);
      setOpen(true);
    } else if (Events.isUpKey(e)) {
      e.preventDefault();
      e.stopPropagation();
      setFocusIndex(itemCount - 1);
      setOpen(true);
    }
  }, [itemCount, setOpen]);
  const handleEscapeKey = useCallback(e => {
    /* istanbul ignore else */
    if (Events.isEscKey(e)) {
      setOpen(false);
      focusButton();
    }
  }, [setOpen, focusButton]);
  useModalManager({
    open: isOpen,
    closeModal: handleEscapeKey,
    modalRef: buttonRef
  });
  useEffect(() => {
    const handler = ({
      target
    }) => {
      // If the event didn't came from part of this component, close the menu.
      // There will be multiple document click listeners but we cant prevent propagation because it will interfere with
      // other instances on the same page

      const isInMenu = menu?.current?.contains(target);
      const isInButton = buttonRef?.current?.contains(target);
      if (!isInMenu && !isInButton) {
        setOpen(false);
      }
    };
    const event = "click";
    document.addEventListener(event, handler, {
      capture: true
    });
    return function cleanup() {
      document.removeEventListener(event, handler, {
        capture: true
      });
    };
  }, [setOpen]);
  const menuButton = menuID => {
    if (renderButton) {
      return renderButton({
        tabIndex: isOpen ? -1 : 0,
        "data-element": "action-popover-button",
        ariaAttributes: {
          "aria-haspopup": "true",
          "aria-label": ariaLabel || l.actionPopover.ariaLabel(),
          "aria-controls": menuID,
          "aria-expanded": `${isOpen}`
        }
      });
    }
    return /*#__PURE__*/React.createElement(StyledButtonIcon, {
      role: "button",
      "aria-haspopup": "true",
      "aria-label": ariaLabel || l.actionPopover.ariaLabel(),
      "aria-controls": menuID,
      "aria-expanded": isOpen,
      tabIndex: isOpen ? -1 : 0,
      "data-element": "action-popover-button"
    }, /*#__PURE__*/React.createElement(ButtonIcon, {
      type: "ellipsis_vertical"
    }));
  };
  const parentID = id || `ActionPopoverButton_${guid}`;
  const menuID = `ActionPopoverMenu_${guid}`;
  const menuProps = {
    buttonRef,
    parentID,
    setFocusIndex,
    focusIndex,
    menuID,
    isOpen,
    setOpen,
    rightAlignMenu,
    placement,
    horizontalAlignment
  };
  return /*#__PURE__*/React.createElement(MenuButton, _extends({
    id: parentID,
    "data-component": "action-popover-wrapper",
    onKeyDown: onButtonKeyDown,
    onClick: onButtonClick,
    isOpen,
    ref: buttonRef
  }, rest), menuButton(menuID), /*#__PURE__*/React.createElement(ActionPopoverContext.Provider, {
    value: {
      setOpenPopover: setOpen,
      focusButton,
      submenuPosition,
      isOpenPopover: isOpen
    }
  }, isOpen && /*#__PURE__*/React.createElement(Popover, {
    placement: mappedPlacement,
    reference: buttonRef
  }, /*#__PURE__*/React.createElement(ActionPopoverMenu, _extends({
    "data-component": "action-popover",
    ref: menu
  }, menuProps), children))));
};
export default ActionPopover;