import React from "react";
import { MarginProps } from "styled-system";
import { Alignment } from "./action-popover-context";
export interface RenderButtonProps {
    tabIndex: number;
    "data-element": string;
    ariaAttributes: {
        "aria-haspopup": string;
        "aria-label": string;
        "aria-controls": string;
        "aria-expanded": string;
    };
}
export interface ActionPopoverProps extends MarginProps {
    /** Children for popover component */
    children?: React.ReactNode;
    /** Horizontal alignment of menu items content */
    horizontalAlignment?: Alignment;
    /** Sets submenu position */
    submenuPosition?: Alignment;
    /** Unique ID */
    id?: string;
    /** Callback to be called on menu open */
    onOpen?: () => void;
    /** Callback to be called on menu close */
    onClose?: () => void;
    /** Set whether the menu should open above or below the button */
    placement?: "bottom" | "top";
    /** Render a custom menu button to override default ellipsis icon */
    renderButton?: (buttonProps: RenderButtonProps) => React.ReactNode;
    /** Boolean to control whether menu should align to right */
    rightAlignMenu?: boolean;
    /** Prop to specify an aria-label for the component */
    "aria-label"?: string;
}
export declare const ActionPopover: ({ children, id, onOpen, onClose, rightAlignMenu, renderButton, placement, horizontalAlignment, submenuPosition, "aria-label": ariaLabel, ...rest }: ActionPopoverProps) => React.JSX.Element;
export default ActionPopover;
