function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useMemo, useContext, useState, useEffect } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { Menu } from "../action-popover.style";
import Events from "../../../__internal__/utils/helpers/events";
import ActionPopoverItem from "../action-popover-item/action-popover-item.component";
import ActionPopoverDivider from "../action-popover-divider/action-popover-divider.component";
import ActionPopoverContext from "../action-popover-context";
const ActionPopoverMenu = /*#__PURE__*/React.forwardRef(({
  children,
  parentID,
  focusIndex,
  isOpen,
  menuID,
  setOpen,
  setFocusIndex,
  placement = "bottom",
  horizontalAlignment,
  isASubmenu,
  ...rest
}, ref) => {
  const context = useContext(ActionPopoverContext);
  !context ? process.env.NODE_ENV !== "production" ? invariant(false, "ActionPopoverMenu must be used within an ActionPopover component") : invariant(false) : void 0;
  const {
    focusButton,
    submenuPosition
  } = context;
  !(setOpen && setFocusIndex && typeof focusIndex !== "undefined") ? process.env.NODE_ENV !== "production" ? invariant(false, "ActionPopoverMenu must be used within an ActionPopover or ActionPopoverItem component") : invariant(false) : void 0;
  const hasProperChildren = useMemo(() => {
    const incorrectChild = React.Children.toArray(children).find(child => {
      if (! /*#__PURE__*/React.isValidElement(child)) {
        return true;
      }
      return child.type.displayName !== ActionPopoverItem.displayName && child.type.displayName !== ActionPopoverDivider.displayName;
    });
    return !incorrectChild;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? invariant(false, `ActionPopoverMenu only accepts children of type \`${ActionPopoverItem.displayName}\`` + ` and \`${ActionPopoverDivider.displayName}\`.`) : invariant(false) : void 0;
  const items = useMemo(() => {
    return React.Children.toArray(children).filter(child => {
      return /*#__PURE__*/React.isValidElement(child) && child.type === ActionPopoverItem;
    });
  }, [children]);
  const isItemDisabled = useCallback(value => {
    const item = items[value];
    // The invariant will be triggered before this else path can be explored, hence the ignore else.
    // istanbul ignore else
    return /*#__PURE__*/React.isValidElement(item) && item.props.disabled;
  }, [items]);
  const firstFocusableItem = items.findIndex((_, index) => !isItemDisabled(index));

  // FIX-ME: FE-6248
  // Once we no longer support Node 16, this function can be removed and `findLastIndex()` can be used in it's place.
  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findLastIndex
  function findLastFocusableItem() {
    let lastFocusableItem = -1;
    for (let i = items.length - 1; i >= 0; i--) {
      if (!isItemDisabled(i)) {
        lastFocusableItem = i;
        break;
      }
    }
    return lastFocusableItem;
  }
  const lastFocusableItem = findLastFocusableItem();
  useEffect(() => {
    if (isOpen && firstFocusableItem !== -1) setFocusIndex(firstFocusableItem);
  }, [isOpen, firstFocusableItem, setFocusIndex]);
  const onKeyDown = useCallback(e => {
    if (Events.isTabKey(e)) {
      e.preventDefault();
      // TAB: close menu and allow focus to change to the next focusable element
      focusButton();
      setOpen(false);
    } else if (Events.isDownKey(e)) {
      // DOWN: focus on the next item or first non-disabled item
      e.preventDefault();
      e.stopPropagation();
      let indexValue = focusIndex + 1;
      while (indexValue < items.length && isItemDisabled(indexValue)) {
        indexValue += 1;
      }
      if (indexValue >= items.length) {
        indexValue = firstFocusableItem;
      }
      setFocusIndex(indexValue);
    } else if (Events.isUpKey(e)) {
      // UP: focus on the previous item or last non-disabled item
      e.preventDefault();
      e.stopPropagation();
      let indexValue = focusIndex - 1;
      while (indexValue >= firstFocusableItem && isItemDisabled(indexValue)) {
        indexValue -= 1;
      }
      if (indexValue < firstFocusableItem) {
        indexValue = lastFocusableItem;
      }
      setFocusIndex(indexValue);
    } else if (Events.isHomeKey(e)) {
      // HOME: focus on the first non-disabled item
      e.preventDefault();
      e.stopPropagation();
      const indexValue = firstFocusableItem;
      setFocusIndex(indexValue);
    } else if (Events.isEndKey(e)) {
      // END: focus on the last non-disabled item
      e.preventDefault();
      e.stopPropagation();
      const indexValue = lastFocusableItem;
      setFocusIndex(indexValue);
    } else if (e.key.length === 1) {
      // Any printable character: focus on the next non-disabled item on the list that starts with that character
      // Selection should wrap to the start of the list
      e.stopPropagation();
      let firstMatch;
      let nextMatch;
      items.forEach((item, index) => {
        if ( /*#__PURE__*/React.isValidElement(item) && !isItemDisabled(index) && item.props.children.toLowerCase().startsWith(e.key.toLowerCase())) {
          // istanbul ignore else
          if (firstMatch === undefined) {
            firstMatch = index;
          }
          if (index > focusIndex && nextMatch === undefined) {
            nextMatch = index;
          }
        }
      });
      if (nextMatch !== undefined) {
        setFocusIndex(nextMatch);
      } else if (firstMatch !== undefined) {
        setFocusIndex(firstMatch);
      }
    }
  }, [focusButton, setOpen, focusIndex, items, isItemDisabled, setFocusIndex, firstFocusableItem, lastFocusableItem]);
  const [childHasSubmenu, setChildHasSubmenu] = useState(false);
  const [childHasIcon, setChildHasIcon] = useState(false);
  const [currentSubmenuPosition, setCurrentSubmenuPosition] = useState(submenuPosition);
  const clonedChildren = useMemo(() => {
    let index = 0;
    return React.Children.map(children, child => {
      if ( /*#__PURE__*/React.isValidElement(child) && child.type === ActionPopoverItem) {
        index += 1;
        return /*#__PURE__*/React.cloneElement(child, {
          focusItem: isOpen && focusIndex === index - 1,
          placement: child.props.submenu ? placement : undefined,
          horizontalAlignment,
          childHasSubmenu,
          setChildHasSubmenu,
          childHasIcon,
          setChildHasIcon,
          currentSubmenuPosition,
          setCurrentSubmenuPosition,
          isASubmenu
        });
      }
      return child;
    });
  }, [children, focusIndex, isOpen, placement, horizontalAlignment, childHasSubmenu, childHasIcon, currentSubmenuPosition, isASubmenu]);
  return /*#__PURE__*/React.createElement(Menu, _extends({
    "data-component": "action-popover",
    isOpen: isOpen,
    onKeyDown: onKeyDown,
    id: menuID,
    "aria-labelledby": parentID,
    ref: ref,
    role: "list"
  }, rest), clonedChildren);
});
if (process.env.NODE_ENV !== "production") {
  ActionPopoverMenu.propTypes = {
    "children": PropTypes.node,
    "data-element": PropTypes.string,
    "focusIndex": PropTypes.number,
    "horizontalAlignment": PropTypes.oneOf(["left", "right"]),
    "isASubmenu": PropTypes.bool,
    "isOpen": PropTypes.bool,
    "menuID": PropTypes.string,
    "parentID": PropTypes.string,
    "placement": PropTypes.oneOf(["bottom", "top"]),
    "role": PropTypes.string,
    "setFocusIndex": PropTypes.func,
    "setOpen": PropTypes.func,
    "style": PropTypes.shape({
      "bottom": PropTypes.string,
      "left": PropTypes.oneOfType([PropTypes.number, PropTypes.string]).isRequired,
      "right": PropTypes.oneOfType([PropTypes.number, PropTypes.string]).isRequired,
      "top": PropTypes.string
    })
  };
}
ActionPopoverMenu.displayName = "ActionPopoverMenu";
export default ActionPopoverMenu;