import React from "react";
import { ButtonIconPosition, ButtonTypes, SizeOptions } from "../../button/button.component";
import { IconType } from "../../icon";
export declare type ActionPopoverMenuButtonAria = {
    "aria-haspopup": string;
    "aria-label": string;
    "aria-controls": string;
    "aria-expanded": string;
};
export interface ActionPopoverMenuButtonProps {
    /** ARIA attributes to be applied to the button HTML element */
    ariaAttributes: ActionPopoverMenuButtonAria;
    /** Variant of the menu button */
    buttonType?: ButtonTypes;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element": string;
    /** Content of the button */
    children?: string;
    /** Defines an Icon position related to the children: "before" | "after" */
    iconPosition?: ButtonIconPosition;
    /** Defines an Icon type within the button */
    iconType?: IconType;
    /** Assigns a size to the button: "small" | "medium" | "large" */
    size?: SizeOptions;
    /** Overrides the default tabindex of the component */
    tabIndex: number;
}
export declare const ActionPopoverMenuButton: {
    ({ buttonType, iconType, iconPosition, size, children, ...props }: ActionPopoverMenuButtonProps): React.JSX.Element;
    displayName: string;
};
export default ActionPopoverMenuButton;
