function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useRef, useState, useContext } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { MenuItemIcon, SubMenuItemIcon, StyledMenuItem, StyledMenuItemInnerText, StyledMenuItemOuterContainer, StyledMenuItemWrapper } from "../action-popover.style";
import Events from "../../../__internal__/utils/helpers/events";
import createGuid from "../../../__internal__/utils/helpers/guid";
import ActionPopoverContext from "../action-popover-context";
import ActionPopoverMenu from "../action-popover-menu/action-popover-menu.component";
const INTERVAL = 150;
function checkRef(ref) {
  return Boolean(ref && ref.current);
}
function calculateSubmenuPosition(ref, submenuRef, submenuPosition, currentSubmenuPosition) {
  /* istanbul ignore if */

  if (!ref.current || !submenuRef.current) return currentSubmenuPosition || submenuPosition;
  const {
    left,
    right
  } = ref.current.getBoundingClientRect();
  const {
    offsetWidth
  } = submenuRef.current;
  const windowWidth = document.body.clientWidth;
  if (submenuPosition === "left") {
    return left >= offsetWidth ? "left" : "right";
  }
  return windowWidth >= right + offsetWidth ? "right" : "left";
}
export const ActionPopoverItem = ({
  children,
  icon,
  disabled = false,
  onClick: onClickProp,
  submenu,
  placement = "bottom",
  focusItem,
  download,
  href,
  horizontalAlignment,
  childHasSubmenu,
  childHasIcon,
  currentSubmenuPosition,
  setChildHasSubmenu,
  setChildHasIcon,
  setCurrentSubmenuPosition,
  isASubmenu = false,
  ...rest
}) => {
  const context = useContext(ActionPopoverContext);
  !context ? process.env.NODE_ENV !== "production" ? invariant(false, "ActionPopoverItem must be used within an ActionPopover component") : invariant(false) : void 0;
  !( /*#__PURE__*/React.isValidElement(submenu) ? submenu.type === ActionPopoverMenu : true) ? process.env.NODE_ENV !== "production" ? invariant(false, "ActionPopoverItem only accepts submenu of type `ActionPopoverMenu`") : invariant(false) : void 0;
  const {
    setOpenPopover,
    isOpenPopover,
    focusButton,
    submenuPosition
  } = context;
  const isHref = !!href;
  const [containerPosition, setContainerPosition] = useState(undefined);
  const [guid] = useState(createGuid());
  const [isOpen, setOpen] = useState(false);
  const [focusIndex, setFocusIndex] = useState(0);
  const submenuRef = useRef(null);
  const ref = useRef(null);
  const mouseEnterTimer = useRef(null);
  const mouseLeaveTimer = useRef(null);
  useEffect(() => {
    if (!isOpenPopover) {
      setOpen(false);
    }
  }, [isOpenPopover]);
  useEffect(() => {
    if (icon) {
      setChildHasIcon?.(true);
    }
    if (submenu) {
      setChildHasSubmenu?.(true);
    }
  }, [icon, setChildHasSubmenu, setChildHasIcon, submenu]);
  const alignSubmenu = useCallback(() => {
    const checkCalculatedSubmenuPosition = calculateSubmenuPosition(ref, submenuRef, submenuPosition, currentSubmenuPosition);
    setCurrentSubmenuPosition?.(checkCalculatedSubmenuPosition);
    return checkRef(ref) && checkRef(submenuRef) && submenu;
  }, [submenu, setCurrentSubmenuPosition, submenuPosition, currentSubmenuPosition]);
  useEffect(() => {
    const getContainerPosition = () => {
      /* istanbul ignore if */
      if (!ref.current || !submenuRef.current) return undefined;
      const {
        offsetWidth: submenuWidth
      } = submenuRef.current;
      const leftAlignedSubmenu = currentSubmenuPosition === "left";
      const leftValue = leftAlignedSubmenu ? -submenuWidth : "auto";
      const rightValue = leftAlignedSubmenu ? "auto" : -submenuWidth;
      const yPositionName = placement === "top" ? "bottom" : "top";
      return {
        left: leftValue,
        [yPositionName]: "calc(-1 * var(--spacing100))",
        right: rightValue
      };
    };
    setContainerPosition(getContainerPosition);
  }, [submenu, currentSubmenuPosition, placement]);
  useEffect(() => {
    if (submenu) {
      alignSubmenu();
    }
  }, [alignSubmenu, submenu]);

  // focuses item on opening of actionPopover submenu
  useEffect(() => {
    if (focusItem) {
      ref.current?.focus({
        preventScroll: true
      });
    }
  }, [focusItem]);
  useEffect(() => {
    return function cleanup() {
      if (mouseEnterTimer.current) clearTimeout(mouseEnterTimer.current);
      if (mouseLeaveTimer.current) clearTimeout(mouseLeaveTimer.current);
    };
  }, []);
  useEffect(() => {
    const event = "resize";
    window.addEventListener(event, alignSubmenu);
    return function cleanup() {
      window.removeEventListener(event, alignSubmenu);
    };
  }, [alignSubmenu]);
  const onClick = useCallback(e => {
    e.stopPropagation();
    if (!disabled) {
      setOpenPopover(false);
      focusButton();
      if (onClickProp) {
        onClickProp(e);
      }
    } else {
      ref.current?.focus();
      e.preventDefault();
    }
  }, [disabled, focusButton, onClickProp, setOpenPopover]);
  const onKeyDown = useCallback(e => {
    if (Events.isSpaceKey(e)) {
      e.preventDefault();
      e.stopPropagation();
    } else if (!disabled) {
      if (submenu) {
        if (currentSubmenuPosition === "left") {
          // LEFT: open if has submenu and left aligned otherwise close submenu
          if (Events.isLeftKey(e) || Events.isEnterKey(e)) {
            setOpen(true);
            setFocusIndex(0);
            e.stopPropagation();
          } else if (Events.isRightKey(e)) {
            setOpen(false);
            ref.current?.focus();
            e.stopPropagation();
          }
        } else {
          // RIGHT: open if has submenu and right aligned otherwise close submenu
          if (Events.isRightKey(e) || Events.isEnterKey(e)) {
            setOpen(true);
            setFocusIndex(0);
            e.stopPropagation();
          }
          if (Events.isLeftKey(e)) {
            setOpen(false);
            ref.current?.focus();
            e.stopPropagation();
          }
        }
        e.preventDefault();
      } else if (Events.isEnterKey(e)) {
        if (isHref && download) {
          ref.current?.click();
        }
        e.preventDefault();
        // this type assertion should be safe as the onclick handler is designed to catch events propagating from the inner buttons
        onClick(e);
      }
    } else if (Events.isEnterKey(e)) {
      e.stopPropagation();
    }
  }, [disabled, download, isHref, onClick, submenu, currentSubmenuPosition]);
  const itemSubmenuProps = {
    ...(!disabled && {
      onClick: e => {
        setOpen(true);
        ref.current?.focus();
        e.preventDefault();
        e.stopPropagation();
      }
    }),
    "aria-haspopup": "true",
    "aria-controls": `ActionPopoverMenu_${guid}`,
    "aria-expanded": isOpen
  };
  const wrapperProps = {
    ...(!disabled && {
      onMouseEnter: e => {
        if (mouseEnterTimer.current) clearTimeout(mouseEnterTimer.current);
        setFocusIndex(-1);
        mouseEnterTimer.current = setTimeout(() => {
          setOpen(true);
        }, INTERVAL);
        e.stopPropagation();
      },
      onMouseLeave: e => {
        if (mouseLeaveTimer.current) clearTimeout(mouseLeaveTimer.current);
        mouseLeaveTimer.current = setTimeout(() => {
          setOpen(false);
        }, INTERVAL);
        e.stopPropagation();
      }
    })
  };
  const renderMenuItemIcon = () => {
    return icon && /*#__PURE__*/React.createElement(MenuItemIcon, {
      type: icon,
      "data-element": "action-popover-menu-item-icon",
      horizontalAlignment: horizontalAlignment,
      submenuPosition: currentSubmenuPosition,
      childHasIcon: childHasIcon,
      childHasSubmenu: childHasSubmenu,
      hasIcon: !!icon,
      hasSubmenu: !!submenu,
      isASubmenu: isASubmenu
    });
  };
  return /*#__PURE__*/React.createElement(StyledMenuItemWrapper, submenu && wrapperProps, /*#__PURE__*/React.createElement("div", {
    onKeyDown: onKeyDown,
    role: "presentation"
  }, /*#__PURE__*/React.createElement(StyledMenuItem, _extends({}, rest, {
    ref: ref,
    onClick: onClick,
    type: "button",
    tabIndex: 0,
    isDisabled: disabled,
    horizontalAlignment: horizontalAlignment,
    submenuPosition: currentSubmenuPosition,
    hasSubmenu: !!submenu,
    childHasSubmenu: childHasSubmenu
  }, disabled && {
    "aria-disabled": true
  }, isHref && {
    as: "a",
    download,
    href
  }, submenu && itemSubmenuProps), submenu && checkRef(ref) && currentSubmenuPosition === "left" ? /*#__PURE__*/React.createElement(SubMenuItemIcon, {
    "data-element": "action-popover-menu-item-chevron",
    type: "chevron_left_thick"
  }) : null, /*#__PURE__*/React.createElement(StyledMenuItemOuterContainer, null, horizontalAlignment === "left" ? renderMenuItemIcon() : null, /*#__PURE__*/React.createElement(StyledMenuItemInnerText, {
    "data-element": "action-popover-menu-item-inner-text",
    horizontalAlignment: horizontalAlignment,
    submenuPosition: currentSubmenuPosition,
    isASubmenu: isASubmenu,
    childHasSubmenu: childHasSubmenu,
    childHasIcon: childHasIcon,
    hasIcon: !!icon,
    hasSubmenu: !!submenu
  }, children), horizontalAlignment === "right" ? renderMenuItemIcon() : null), submenu && checkRef(ref) && currentSubmenuPosition === "right" ? /*#__PURE__*/React.createElement(SubMenuItemIcon, {
    "data-element": "action-popover-menu-item-chevron",
    type: "chevron_right_thick"
  }) : null), /*#__PURE__*/React.isValidElement(submenu) ? /*#__PURE__*/React.cloneElement(submenu, {
    parentID: `ActionPopoverItem_${guid}`,
    menuID: `ActionPopoverMenu_${guid}`,
    "data-element": "action-popover-submenu",
    isOpen,
    ref: submenuRef,
    style: containerPosition,
    setOpen,
    setFocusIndex,
    focusIndex,
    isASubmenu: true,
    horizontalAlignment
  }) : null));
};
ActionPopoverItem.displayName = "ActionPopoverItem";
export default ActionPopoverItem;