import React from "react";
import { Alignment } from "../action-popover-context";
import { IconType } from "../../icon";
export interface ActionPopoverItemProps {
    /** The text label to display for this Item */
    children: string;
    /** Flag to indicate if item is disabled */
    disabled?: boolean;
    /** allows to provide download prop that works dependent with href */
    download?: boolean;
    /** allows to provide href prop */
    href?: string;
    /** The name of the icon to display next to the label */
    icon?: IconType;
    /** Callback to run when item is clicked */
    onClick?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Submenu component for item */
    submenu?: React.ReactNode;
    /** @ignore @private */
    placement?: "top" | "bottom";
    /** @ignore @private */
    focusItem?: boolean;
    /** @ignore @private */
    horizontalAlignment?: Alignment;
    /** @ignore @private */
    childHasSubmenu?: boolean;
    /** @ignore @private */
    childHasIcon?: boolean;
    /** @ignore @private */
    currentSubmenuPosition?: Alignment;
    /** @ignore @private */
    setChildHasSubmenu?: (value: boolean) => void;
    /** @ignore @private */
    setChildHasIcon?: (value: boolean) => void;
    /** @ignore @private */
    setCurrentSubmenuPosition?: (value: Alignment) => void;
    /** @ignore @private */
    isASubmenu?: boolean;
}
export declare const ActionPopoverItem: {
    ({ children, icon, disabled, onClick: onClickProp, submenu, placement, focusItem, download, href, horizontalAlignment, childHasSubmenu, childHasIcon, currentSubmenuPosition, setChildHasSubmenu, setChildHasIcon, setCurrentSubmenuPosition, isASubmenu, ...rest }: ActionPopoverItemProps): React.JSX.Element;
    displayName: string;
};
export default ActionPopoverItem;
