/// <reference types="react" />
declare const StyledAccordionGroup: import("styled-components").StyledComponent<"div", any, {}, never>;
export interface StyledAccordionContainerProps {
    /** Toggles left and right borders, set to none when variant is subtle */
    borders?: "default" | "full" | "none";
    /** (Deprecated) Renders the accordion heading in the style of a tertiary button */
    buttonHeading?: boolean;
    /** (Deprecated) Sets background as white or transparent, set to transparent when variant is subtle */
    scheme?: "white" | "transparent";
    /** Sets accordion width */
    width?: string;
    /** Sets accordion variant */
    variant?: "standard" | "subtle";
}
declare const StyledAccordionContainer: import("styled-components").StyledComponent<"div", any, StyledAccordionContainerProps, never>;
interface StyledAccordionTitleProps {
    size?: "large" | "small";
    variant?: "standard" | "subtle";
}
declare const StyledAccordionTitle: import("styled-components").StyledComponent<"h3", any, StyledAccordionTitleProps, never>;
declare const StyledAccordionSubTitle: import("styled-components").StyledComponent<"span", any, {}, never>;
interface StyledAccordionIconProps {
    isExpanded?: boolean;
    iconAlign?: "left" | "right";
}
declare const StyledAccordionIcon: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("../icon").IconProps & import("react").RefAttributes<HTMLSpanElement>>, any, StyledAccordionIconProps, never>;
interface StyledAccordionHeadingsContainerProps {
    buttonHeading?: boolean;
    hasValidationIcon?: boolean;
}
declare const StyledAccordionHeadingsContainer: import("styled-components").StyledComponent<"div", any, StyledAccordionHeadingsContainerProps, never>;
interface StyledAccordionTitleContainerProps {
    buttonHeading?: boolean;
    buttonWidth?: number | string;
    hasButtonProps?: boolean;
    iconAlign?: "left" | "right";
    size?: "large" | "small";
    isExpanded?: boolean;
    variant?: "standard" | "subtle";
}
declare const StyledAccordionTitleContainer: import("styled-components").StyledComponent<"div", any, StyledAccordionTitleContainerProps, never>;
export interface StyledAccordionContentContainerProps {
    isExpanded?: boolean;
    maxHeight?: string | number;
}
declare const StyledAccordionContentContainer: import("styled-components").StyledComponent<"div", any, StyledAccordionContentContainerProps, never>;
export interface StyledAccordionContentProps {
    disableContentPadding?: boolean;
    variant?: "standard" | "subtle";
}
declare const StyledAccordionContent: import("styled-components").StyledComponent<"div", any, StyledAccordionContentProps, never>;
export { StyledAccordionGroup, StyledAccordionContainer, StyledAccordionHeadingsContainer, StyledAccordionSubTitle, StyledAccordionTitleContainer, StyledAccordionTitle, StyledAccordionIcon, StyledAccordionContent, StyledAccordionContentContainer, };
