function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useRef, useEffect, useCallback } from "react";
import PropTypes from "prop-types";
import useResizeObserver from "../../hooks/__internal__/useResizeObserver";
import createGuid from "../../__internal__/utils/helpers/guid";
import Events from "../../__internal__/utils/helpers/events";
import Logger from "../../__internal__/utils/logger";
import { StyledAccordionContainer, StyledAccordionHeadingsContainer, StyledAccordionTitleContainer, StyledAccordionTitle, StyledAccordionSubTitle, StyledAccordionIcon, StyledAccordionContentContainer, StyledAccordionContent } from "./accordion.style";
import ValidationIcon from "../../__internal__/validations";
let deprecatedSchemeWarnTriggered = false;
let deprecatedButtonHeadingWarnTriggered = false;
const Accordion = /*#__PURE__*/React.forwardRef(({
  borders = "default",
  defaultExpanded,
  expanded,
  onChange,
  children,
  handleKeyboardAccessibility,
  id,
  index,
  iconType,
  iconAlign,
  scheme = "white",
  size = "large",
  subTitle,
  title,
  width,
  headerSpacing,
  disableContentPadding = false,
  error,
  warning,
  info,
  buttonHeading,
  buttonWidth = "150px",
  openTitle,
  variant = "standard",
  ...rest
}, ref) => {
  if (!deprecatedSchemeWarnTriggered && scheme === "transparent") {
    deprecatedSchemeWarnTriggered = true;
    Logger.deprecate("The `scheme` prop for `Accordion` component is deprecated and will soon be removed.");
  }
  if (!deprecatedButtonHeadingWarnTriggered && buttonHeading) {
    deprecatedButtonHeadingWarnTriggered = true;
    Logger.deprecate("The `buttonHeading` prop for `Accordion` component is deprecated and will soon be removed. Please use `subtle` variant instead.");
  }
  const isControlled = expanded !== undefined;
  const [isExpandedInternal, setIsExpandedInternal] = useState(defaultExpanded || false);
  const [contentHeight, setContentHeight] = useState(isExpandedInternal ? "auto" : 0);
  const accordionContent = useRef(null);
  const isExpanded = isControlled ? expanded : isExpandedInternal;
  useResizeObserver(accordionContent, () => {
    setContentHeight(accordionContent.current?.scrollHeight);
  });
  useEffect(() => {
    setContentHeight(accordionContent.current?.scrollHeight);
  }, [isExpanded]);
  const toggleAccordion = useCallback(ev => {
    if (!isControlled) {
      setIsExpandedInternal(!isExpanded);
    }
    if (onChange) onChange(ev, !isExpanded);
  }, [isControlled, isExpanded, onChange]);
  const handleKeyDown = useCallback(ev => {
    if (handleKeyboardAccessibility) {
      handleKeyboardAccessibility(ev, index);
    }
    if (Events.isEnterKey(ev) || Events.isSpaceKey(ev)) {
      toggleAccordion(ev);
    }
  }, [handleKeyboardAccessibility, index, toggleAccordion]);
  const guid = useRef(createGuid());
  const accordionId = id || `Accordion_${guid.current}`;
  const headerId = `AccordionHeader_${guid.current}`;
  const contentId = `AccordionContent_${guid.current}`;
  const showValidationIcon = !!(error || warning || info);
  const getTitle = () => isExpanded ? openTitle || title : title;
  const getIconType = () => size === "small" || variant === "subtle" ? "chevron_down_thick" : "chevron_down";
  return /*#__PURE__*/React.createElement(StyledAccordionContainer, _extends({
    id: accordionId,
    "data-component": "accordion",
    width: width,
    borders: variant === "subtle" ? "none" : borders,
    scheme: scheme,
    buttonHeading: buttonHeading,
    variant: variant
  }, rest), /*#__PURE__*/React.createElement(StyledAccordionTitleContainer, _extends({
    "data-element": "accordion-title-container",
    id: headerId,
    "aria-expanded": isExpanded,
    "aria-controls": contentId,
    onClick: toggleAccordion,
    onKeyDown: handleKeyDown,
    tabIndex: 0,
    iconAlign: iconAlign || (variant === "standard" ? "right" : "left"),
    ref: ref,
    size: size,
    buttonHeading: buttonHeading,
    isExpanded: isExpanded,
    variant: variant,
    buttonWidth: buttonWidth,
    hasButtonProps: buttonHeading && !(typeof headerSpacing === "undefined"),
    role: "button"
  }, buttonHeading && {
    p: 0
  }, headerSpacing), /*#__PURE__*/React.createElement(StyledAccordionHeadingsContainer, {
    "data-element": "accordion-headings-container",
    hasValidationIcon: showValidationIcon,
    buttonHeading: buttonHeading
  }, !buttonHeading && typeof title === "string" ? /*#__PURE__*/React.createElement(StyledAccordionTitle, {
    "data-element": "accordion-title",
    size: size,
    variant: variant
  }, title) : getTitle(), !buttonHeading && variant !== "subtle" && /*#__PURE__*/React.createElement(React.Fragment, null, showValidationIcon && /*#__PURE__*/React.createElement(ValidationIcon, {
    error: error,
    warning: warning,
    info: info,
    tooltipPosition: "top",
    tabIndex: 0,
    ml: 1
  }), subTitle && size === "large" && variant === "standard" && /*#__PURE__*/React.createElement(StyledAccordionSubTitle, null, subTitle))), /*#__PURE__*/React.createElement(StyledAccordionIcon, {
    "data-element": "accordion-icon",
    type: iconType || getIconType(),
    isExpanded: isExpanded,
    iconAlign: iconAlign || (variant === "standard" ? "right" : "left")
  })), /*#__PURE__*/React.createElement(StyledAccordionContentContainer, {
    isExpanded: isExpanded,
    maxHeight: contentHeight
  }, /*#__PURE__*/React.createElement(StyledAccordionContent, {
    role: "region",
    "data-element": "accordion-content",
    id: contentId,
    "aria-labelledby": headerId,
    ref: accordionContent,
    disableContentPadding: disableContentPadding,
    variant: variant
  }, children)));
});
if (process.env.NODE_ENV !== "production") {
  Accordion.propTypes = {
    "borders": PropTypes.oneOf(["default", "full", "none"]),
    "buttonHeading": PropTypes.bool,
    "buttonWidth": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "children": PropTypes.node,
    "defaultExpanded": PropTypes.bool,
    "disableContentPadding": PropTypes.bool,
    "error": PropTypes.string,
    "expanded": PropTypes.bool,
    "handleKeyboardAccessibility": PropTypes.func,
    "headerSpacing": PropTypes.shape({
      "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "p": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "padding": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pl": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "px": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "py": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])
    }),
    "iconAlign": PropTypes.oneOf(["left", "right"]),
    "iconType": PropTypes.oneOf(["chevron_down_thick", "chevron_down", "dropdown"]),
    "id": PropTypes.string,
    "index": PropTypes.number,
    "info": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "onChange": PropTypes.func,
    "openTitle": PropTypes.string,
    "p": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "padding": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pl": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "px": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "py": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "scheme": PropTypes.oneOf(["transparent", "white"]),
    "size": PropTypes.oneOf(["large", "small"]),
    "subTitle": PropTypes.string,
    "title": PropTypes.node,
    "variant": PropTypes.oneOf(["standard", "subtle"]),
    "warning": PropTypes.string,
    "width": PropTypes.string
  };
}
export { Accordion };
Accordion.displayName = "Accordion";
export default Accordion;