import { ReactWrapper } from "enzyme";
import { LayoutProps, FlexboxProps, BackgroundProps, PositionProps, GridProps } from "styled-system";
import { mockMatchMedia } from "./mock-match-media";
declare const toCSSCase: (str: string) => string;
declare const assertStyleMatch: any;
declare const makeArrayKeys: (n: number) => number[];
declare const keyboard: Record<string, () => void>;
declare const simulate: {
    keydown: Record<string, (target: ReactWrapper<any>, { shiftKey }?: {
        shiftKey: boolean;
    } | undefined) => void>;
};
declare const listFrom: (wrapper: ReactWrapper) => ReactWrapper;
declare const childrenFrom: (node: ReactWrapper) => ReactWrapper;
declare const hoverList: (wrapper: ReactWrapper) => (item: number) => void;
declare const click: unknown;
declare const selectedItemOf: (wrapper: ReactWrapper) => number;
declare const assertKeyboardTraversal: ({ num, nonSelectables, }: {
    num: number;
    nonSelectables?: number[] | undefined;
}) => (wrapper: ReactWrapper) => void;
declare const assertHoverTraversal: ({ num, nonSelectables, }: {
    num: number;
    nonSelectables?: number[] | undefined;
}) => (wrapper: ReactWrapper) => void;
declare const marginProps: readonly [readonly ["m", "margin"], readonly ["ml", "marginLeft"], readonly ["mr", "marginRight"], readonly ["mt", "marginTop"], readonly ["mb", "marginBottom"], readonly ["mx", "marginLeft"], readonly ["mx", "marginRight"], readonly ["my", "marginTop"], readonly ["my", "marginBottom"]];
declare type MarginProps = {
    [K in typeof marginProps[number][0]]?: string | number;
};
declare const paddingProps: readonly [readonly ["p", "padding"], readonly ["pl", "paddingLeft"], readonly ["pr", "paddingRight"], readonly ["pt", "paddingTop"], readonly ["pb", "paddingBottom"], readonly ["px", "paddingLeft"], readonly ["px", "paddingRight"], readonly ["py", "paddingTop"], readonly ["py", "paddingBottom"]];
declare type PaddingProps = {
    [K in typeof paddingProps[number][0]]?: string | number;
};
export declare const getDefaultValue: (value?: string | number) => string | number | undefined;
declare const testStyledSystemMargin: (component: (spacingProps?: MarginProps) => JSX.Element, defaults?: MarginProps, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined, assertOpts?: jest.Options) => void;
declare const testStyledSystemPadding: (component: (spacingProps?: PaddingProps) => JSX.Element, defaults?: PaddingProps, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined, assertOpts?: jest.Options) => void;
declare const testStyledSystemSpacing: (component: (spacingProps?: MarginProps | PaddingProps) => JSX.Element, defaults?: MarginProps | PaddingProps, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined, assertOpts?: jest.Options) => void;
declare const testStyledSystemColor: (component: (colorProperties?: any) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => void) | undefined) => void;
declare const testStyledSystemWidth: (component: (widthProperties?: {
    width: string;
}) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const testStyledSystemHeight: (component: (heightProperties?: {
    height: string;
}) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const testStyledSystemLayout: (component: (layoutProperties?: LayoutProps) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const testStyledSystemFlexBox: (component: (flexboxProperties?: FlexboxProps) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const testStyledSystemGrid: (component: (gridProperties?: GridProps) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const testStyledSystemBackground: (component: (backgroundProperties?: BackgroundProps) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const testStyledSystemPosition: (component: (positionProperties?: PositionProps) => JSX.Element, styleContainer?: ((wrapper: ReactWrapper) => ReactWrapper) | undefined) => void;
declare const expectConsoleOutput: (message: string, type?: "warn" | "error") => () => void;
export { assertStyleMatch, toCSSCase, hoverList, selectedItemOf, childrenFrom, makeArrayKeys, keyboard, assertKeyboardTraversal, assertHoverTraversal, listFrom, click, simulate, mockMatchMedia, testStyledSystemSpacing, testStyledSystemMargin, testStyledSystemPadding, testStyledSystemColor, testStyledSystemWidth, testStyledSystemHeight, testStyledSystemLayout, testStyledSystemFlexBox, testStyledSystemGrid, testStyledSystemBackground, testStyledSystemPosition, expectConsoleOutput, };
