import { act } from "react-dom/test-utils";
import { mockResizeObserver } from "jsdom-testing-mocks";
import { StyledSelectListContainer } from "../components/select/select-list/select-list.style";
const resizeObserver = mockResizeObserver();
export function simulateSelectTextboxEvent(container, eventType,
// eslint-disable-next-line @typescript-eslint/no-explicit-any
...eventArgs) {
  const selectText = container.find('input[type="text"]').first();
  selectText.simulate(eventType, ...eventArgs);
  const selectList = container.find(StyledSelectListContainer).getDOMNode();
  // need to manually trigger a resize to make react-virtual realise that child options should be rendered
  act(() => {
    resizeObserver.mockElementSize(selectList, {
      contentBoxSize: {
        inlineSize: 500,
        blockSize: 180
      }
    });
    resizeObserver.resize();
  });
  if (eventType === "focus") jest.runOnlyPendingTimers();
  container.update();
}
export function simulateDropdownEvent(container, eventType) {
  const dropdown = container.find('[type="dropdown"]').first();
  dropdown.simulate(eventType);
  const selectList = container.find(StyledSelectListContainer).getDOMNode();
  // need to manually trigger a resize to make react-virtual realise that child options should be rendered
  act(() => {
    resizeObserver.mockElementSize(selectList, {
      contentBoxSize: {
        inlineSize: 500,
        blockSize: 180
      }
    });
    resizeObserver.resize();
  });
  container.update();
}