function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useRef, useState } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import guid from "../utils/helpers/guid";
import Icon from "../../components/icon";
import ValidationIconStyle from "./validation-icon.style";
import { InputContext, InputGroupContext } from "../input-behaviour";
import { filterStyledSystemMarginProps } from "../../style/utils";
const getValidationType = ({
  error,
  warning,
  info
}) => {
  if (error) return "error";
  if (warning) return "warning";
  if (info) return "info";
  return null;
};
export const ValidationIcon = ({
  error,
  warning,
  info,
  size,
  onFocus,
  onBlur,
  iconId,
  tooltipId,
  isPartOfInput,
  tabIndex = -1,
  onClick,
  tooltipPosition = "right",
  tooltipFlipOverrides,
  ...rest
}) => {
  const validationTooltipId = useRef(tooltipId || guid());
  const flipBehaviourCheck = Array.isArray(tooltipFlipOverrides) && tooltipFlipOverrides.every(override => ["bottom", "left", "right", "top"].includes(override));
  if (tooltipFlipOverrides) {
    !flipBehaviourCheck ? process.env.NODE_ENV !== "production" ? invariant(false, `The tooltipFlipOverrides prop supplied to ValidationIcon must be an array containing some or all of ["top", "bottom", "left", "right"].`) : invariant(false) : void 0;
  }
  const {
    hasFocus,
    hasMouseOver
  } = useContext(InputContext);
  const {
    hasFocus: groupHasFocus,
    hasMouseOver: groupHasMouseOver
  } = useContext(InputGroupContext);
  const [triggeredByIcon, setTriggeredByIcon] = useState(false);
  const validationType = getValidationType({
    error,
    warning,
    info
  });
  const validationMessage = error || warning || info;
  if (typeof validationMessage !== "string" || !validationType) {
    return null;
  }
  return /*#__PURE__*/React.createElement(ValidationIconStyle, _extends({
    validationType: validationType,
    onClick: onClick,
    onMouseOver: () => setTriggeredByIcon(true),
    onMouseLeave: () => setTriggeredByIcon(false),
    onFocus: e => {
      setTriggeredByIcon(true);
      if (onFocus) onFocus(e);
    },
    onBlur: e => {
      setTriggeredByIcon(false);
      if (onBlur) onBlur(e);
    },
    isPartOfInput: isPartOfInput
  }, filterStyledSystemMarginProps(rest)), /*#__PURE__*/React.createElement(Icon, {
    "aria-describedby": validationTooltipId.current,
    key: `${validationType}-icon`,
    type: validationType,
    tabIndex: tabIndex,
    tooltipId: validationTooltipId.current,
    tooltipMessage: validationMessage,
    tooltipPosition: tooltipPosition,
    tooltipVisible: hasFocus || hasMouseOver || groupHasFocus || groupHasMouseOver || triggeredByIcon,
    tooltipFlipOverrides: isPartOfInput && !tooltipFlipOverrides ? ["top", "bottom"] : tooltipFlipOverrides,
    isPartOfInput: isPartOfInput,
    inputSize: size,
    id: iconId,
    focusable: tabIndex !== -1
  }));
};
export default ValidationIcon;