import React from "react";
import { MarginProps } from "styled-system";
export interface ValidationProps {
    /** Indicate that error has occurred
     * Pass string to display icon, tooltip and red border
     * Pass true boolean to only display red border
     */
    error?: boolean | string;
    /** Indicate additional information
     * Pass string to display icon, tooltip and blue border
     * Pass true boolean to only display blue border
     */
    info?: boolean | string;
    /** Indicate that warning has occurred
     * Pass string to display icon, tooltip and orange border
     * Pass true boolean to only display orange border
     */
    warning?: boolean | string;
}
declare type TooltipPositions = "top" | "bottom" | "left" | "right";
export interface ValidationIconProps extends ValidationProps, Pick<MarginProps, "mr" | "ml"> {
    /** A small string to indicate the size of the icon */
    size?: "small" | "medium" | "large";
    /** The unique id of the component (used with aria-describedby for accessibility) */
    iconId?: string;
    /** Define position of the tooltip */
    tooltipPosition?: TooltipPositions;
    /**
     * Overrides the default flip behaviour of the Tooltip,
     * must be an array containing some or all of ["top", "bottom", "left", "right"]
     * (see https://popper.js.org/docs/v2/modifiers/flip/#fallbackplacements)
     */
    tooltipFlipOverrides?: TooltipPositions[];
    /** Id passed to the tooltip container, used for accessibility purposes */
    tooltipId?: string;
    /** An onClick handler */
    onClick?: (ev: React.MouseEvent<HTMLElement>) => void;
    /** An onBlur handler */
    onBlur?: (ev: React.FocusEvent<HTMLElement>) => void;
    /** An onFocus handler */
    onFocus?: (ev: React.FocusEvent<HTMLElement>) => void;
    /** A boolean to indicate if the icon is part of an input */
    isPartOfInput?: boolean;
    /** Overrides the default tabindex of the component */
    tabIndex?: number;
}
export declare const ValidationIcon: ({ error, warning, info, size, onFocus, onBlur, iconId, tooltipId, isPartOfInput, tabIndex, onClick, tooltipPosition, tooltipFlipOverrides, ...rest }: ValidationIconProps) => React.JSX.Element | null;
export default ValidationIcon;
