import React from "react";
import PropTypes from "prop-types";
import StyledValidationMessage from "./validation-message.style";
const ValidationMessage = ({
  error,
  validationId,
  warning
}) => {
  const validation = error || warning;
  const isStringValidation = typeof validation === "string";
  return isStringValidation ? /*#__PURE__*/React.createElement(StyledValidationMessage, {
    id: validationId,
    isWarning: !!(!error && warning)
  }, validation) : null;
};
export default ValidationMessage;