import React, { useRef } from "react";
import guid from "../utils/helpers/guid";
export const TooltipContext = /*#__PURE__*/React.createContext({});
export const TooltipProvider = ({
  children,
  tooltipPosition,
  helpAriaLabel,
  focusable,
  tooltipVisible,
  disabled,
  target
}) => {
  const tooltipId = useRef(guid());
  return /*#__PURE__*/React.createElement(TooltipContext.Provider, {
    value: {
      tooltipPosition,
      helpAriaLabel,
      focusable,
      tooltipVisible,
      disabled,
      tooltipId,
      target
    }
  }, children);
};