import React from "react";
interface TooltipProviderProps {
    /** The position to display the tooltip */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Control whether the tooltip is visible */
    children: React.ReactNode;
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
    focusable?: boolean;
    tooltipVisible?: boolean;
    disabled?: boolean;
    target?: HTMLElement;
}
interface ToolbarContextProps extends Omit<TooltipProviderProps, "children"> {
    tooltipId?: {
        current: string;
    };
}
export declare const TooltipContext: React.Context<ToolbarContextProps>;
export declare const TooltipProvider: ({ children, tooltipPosition, helpAriaLabel, focusable, tooltipVisible, disabled, target, }: TooltipProviderProps) => React.JSX.Element;
export {};
