function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useEffect, useRef, useState, useCallback } from "react";
import PropTypes from "prop-types";
import throttle from "lodash/throttle";
import StyledStickyFooter from "./sticky-footer.style";
const SCROLL_THROTTLE = 50;
const StickyFooter = ({
  children,
  containerRef,
  disableSticky,
  ...rest
}) => {
  const [isSticky, setIsSticky] = useState(true);
  const footerRef = useRef(null);
  const checkFooterPosition = useCallback(throttle(() => {
    const content = containerRef.current;
    /* Fallback to 0 to satisfy the TypeScript compiler */
    /* footerRef will never be null in this method */
    /* istanbul ignore next */
    const stickyOffset = footerRef.current ? footerRef.current.clientHeight / 2 : 0;
    let fullyScrolled;

    // istanbul ignore else
    if (content) {
      fullyScrolled = content.scrollHeight - content.scrollTop - stickyOffset <= content.clientHeight;
    }
    setIsSticky(!fullyScrolled);
  }, SCROLL_THROTTLE), [containerRef]);
  useEffect(() => {
    const content = containerRef.current;
    content?.addEventListener("scroll", checkFooterPosition, false);
    return () => {
      content?.removeEventListener("scroll", checkFooterPosition, false);
    };
  }, [checkFooterPosition, containerRef]);
  return /*#__PURE__*/React.createElement(StyledStickyFooter, _extends({
    "data-component": "sticky-footer",
    sticky: disableSticky ? false : isSticky,
    ref: footerRef
  }, rest), children);
};
export default StickyFooter;