import React, { useState, useCallback, useMemo } from "react";
import PropTypes from "prop-types";
const RadioButtonMapper = ({
  children,
  name,
  onBlur,
  onChange,
  onMouseDown,
  onKeyDown,
  value
}) => {
  const filteredChildren = useMemo(() => React.Children.toArray(children), [children]);
  const anyChecked = useMemo(() => {
    let result = false;
    filteredChildren.forEach(child => {
      if ( /*#__PURE__*/React.isValidElement(child) && Object.prototype.hasOwnProperty.call(child.props, "defaultChecked")) {
        result = true;
      }
    });
    return result;
  }, [filteredChildren]);
  const isControlled = value !== undefined;
  const [checkedValue, setCheckedValue] = useState(false);
  const onChangeProp = useCallback(event => {
    onChange?.(event);
    /* istanbul ignore else */
    if (!isControlled) {
      setCheckedValue(event.target.value);
    }
  }, [onChange, setCheckedValue, isControlled]);
  const buttons = filteredChildren.map(child => {
    let checked;
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return child;
    }
    if (isControlled) {
      // The user is controlling the input via the value prop
      checked = value === child.props.value;
    } else if (!checkedValue && anyChecked) {
      // Uncontrolled and the user has not made a selection, but at least one has a checked prop
      checked = child.props.defaultChecked || false;
    } else {
      // Uncontrolled, existing selection or none marked as checked
      checked = checkedValue === child.props.value;
    }
    const childProps = {
      defaultChecked: undefined,
      checked,
      name,
      onBlur,
      onMouseDown,
      onChange: onChangeProp,
      onKeyDown
    };
    return /*#__PURE__*/React.cloneElement(child, childProps);
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, buttons);
};
RadioButtonMapper.displayName = "RadioButtonMapper";
export default RadioButtonMapper;