import React from "react";
interface InputEvents {
    /** Callback fired when each RadioButton is blurred */
    onBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
    /** Callback fired when the user selects a RadioButton */
    onChange?: (event: React.ChangeEvent<HTMLInputElement>) => void;
    /** Callback fired on mouse down */
    onMouseDown?: (event: React.MouseEvent<HTMLInputElement>) => void;
    /** Callback fired on key down */
    onKeyDown?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
}
export interface RadioButtonMapperProps extends InputEvents {
    /** The RadioButton objects to be rendered in the group */
    children?: React.ReactNode;
    /** Specifies the name prop to be applied to each button in the group */
    name: string;
    /** Value of the selected RadioButton */
    value?: string | null;
}
export interface MappedChildProps {
    defaultChecked?: boolean;
    checked: boolean;
    name: string;
}
declare const RadioButtonMapper: {
    ({ children, name, onBlur, onChange, onMouseDown, onKeyDown, value, }: RadioButtonMapperProps): React.JSX.Element;
    displayName: string;
};
export default RadioButtonMapper;
