import styled, { css } from "styled-components";
const StyledLabel = styled.label`
  color: var(--colorsUtilityYin090);
  display: block;
  font-weight: var(--fontWeights700);

  ${({
  isRequired
}) => isRequired && css`
      ::after {
        content: "*";
        color: var(--colorsSemanticNegative500);
        font-weight: var(--fontWeights700);
        margin-left: var(--spacing050);
      }
    `}

  ${({
  disabled
}) => disabled && css`
      color: var(--colorsUtilityYin030);
    `}
`;
const DEFAULT_CONTAINER_WIDTH = 30;
export const StyledLabelContainer = styled.div`
  display: flex;
  align-items: center;
  margin-bottom: 8px;

  ${({
  align,
  inline,
  pr,
  pl,
  width
}) => inline && css`
      box-sizing: border-box;
      margin-bottom: 0;
      ${pr && css`
        padding-right: var(${pr === 1 ? "--spacing100" : "--spacing200"});
      `};
      ${pl && css`
        padding-left: var(${pl === 1 ? "--spacing100" : "--spacing200"});
      `};
      justify-content: ${align === "right" ? "flex-end" : "flex-start"};
      width: ${width || DEFAULT_CONTAINER_WIDTH}%;
    `}

  ${({
  optional
}) => optional && css`
      ::after {
        content: "(optional)";
        font-weight: var(--fontWeights400);
        margin-left: var(--spacing050);
        color: var(--colorsUtilityYin055);
      }
    `}
`;
export default StyledLabel;