export interface StyledLabelProps {
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** Flag to configure component as mandatory */
    isRequired?: boolean;
}
declare const StyledLabel: import("styled-components").StyledComponent<"label", any, StyledLabelProps, never>;
export interface StyledLabelContainerProps {
    /** Label alignment */
    align?: "left" | "right";
    /** When true, label is placed in line an input */
    inline?: boolean;
    /** Flag to configure component as optional in Form */
    optional?: boolean;
    /** Padding right, integer multiplied by base spacing constant (8) */
    pr?: 1 | 2;
    /** Padding left, integer multiplied by base spacing constant (8) */
    pl?: 1 | 2;
    /** Label width */
    width?: number;
}
export declare const StyledLabelContainer: import("styled-components").StyledComponent<"div", any, StyledLabelContainerProps, never>;
export default StyledLabel;
