function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useContext } from "react";
import PropTypes from "prop-types";
import Help from "../../components/help";
import StyledLabel, { StyledLabelContainer } from "./label.style";
import ValidationIcon from "../validations/validation-icon.component";
import StyledIconWrapper from "./icon-wrapper.style";
import { InputContext, InputGroupContext } from "../input-behaviour";
const shouldDisplayValidationIcon = ({
  error,
  warning,
  info,
  disabled
}) => {
  const validation = error || warning || info;
  return disabled ? false : typeof validation === "string";
};
const tooltipPosition = ({
  error,
  warning,
  info,
  inline
}) => {
  return (error || warning || info) && inline ? "top" : "right";
};
export const Label = ({
  align = "right",
  as = "label",
  children,
  disabled,
  error,
  help,
  helpIcon,
  htmlFor,
  info,
  inline,
  isRequired,
  labelId,
  optional,
  pr,
  pl,
  tooltipId,
  useValidationIcon = true,
  validationIconId,
  warning,
  width = 30,
  className,
  "aria-label": ariaLabel
}) => {
  const [isFocused, setFocus] = useState(false);
  const {
    onMouseEnter,
    onMouseLeave
  } = useContext(InputContext);
  const {
    onMouseEnter: onGroupMouseEnter,
    onMouseLeave: onGroupMouseLeave
  } = useContext(InputGroupContext);
  const handleMouseEnter = () => {
    if (onMouseEnter) onMouseEnter();
    if (onGroupMouseEnter) onGroupMouseEnter();
  };
  const handleMouseLeave = () => {
    if (onMouseLeave) onMouseLeave();
    if (onGroupMouseLeave) onGroupMouseLeave();
  };
  const icon = () => {
    const wrapperProps = {
      onFocus: () => setFocus(true),
      onBlur: () => setFocus(false)
    };
    if (useValidationIcon && shouldDisplayValidationIcon({
      error,
      warning,
      info,
      disabled
    })) {
      const tooltipPositionValue = tooltipPosition({
        error,
        warning,
        info,
        inline
      });
      return /*#__PURE__*/React.createElement(StyledIconWrapper, null, /*#__PURE__*/React.createElement(ValidationIcon, {
        tooltipId: validationIconId,
        error: error,
        warning: warning,
        info: info,
        tooltipPosition: tooltipPositionValue,
        tooltipFlipOverrides: ["top", "bottom"]
      }));
    }
    return help && /*#__PURE__*/React.createElement(StyledIconWrapper, wrapperProps, /*#__PURE__*/React.createElement(Help, {
      tooltipId: tooltipId,
      type: helpIcon,
      isFocused: isFocused
    }, help));
  };
  return /*#__PURE__*/React.createElement(StyledLabelContainer, {
    align: align,
    inline: inline,
    width: width,
    optional: optional,
    pr: pr,
    pl: pl,
    className: className
  }, /*#__PURE__*/React.createElement(StyledLabel, _extends({
    "data-element": "label",
    disabled: disabled,
    id: labelId
  }, as === "label" ? {
    htmlFor
  } : {}, {
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    isRequired: isRequired,
    as: as,
    "aria-label": ariaLabel
  }), children), icon());
};
export default /*#__PURE__*/React.memo(Label);